/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FieldType;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public abstract class Field {
    private List<FieldCondition> conditions;
    private String type;
    private String key;
    private String label;
    private String placeholder;
    private String value;
    private boolean valueSavable = true;
    private boolean updateValuesOnChange = false;

    private Field() {
    }

    protected Field(FieldType type, String key, String label) {
        this(type.name(), key, label, true);
    }

    protected Field(String type, String key, String label) {
        this(type, key, label, true);
    }

    protected Field(FieldType type, String key, String label, boolean valueSavable) {
        this(type.name(), key, label, valueSavable);
    }

    protected Field(String type, String key, String label, boolean valueSavable) {
        this.type = type;
        this.key = key;
        this.label = label;
        this.setValueSavable(valueSavable);
    }

    public List<FieldCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<FieldCondition> conditions) {
        this.conditions = conditions;
    }

    public String getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type.name();
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected boolean isValueSavable() {
        return this.valueSavable;
    }

    protected void setValueSavable(boolean valueSavable) {
        this.valueSavable = valueSavable;
    }

    public boolean isUpdateValuesOnChange() {
        return this.updateValuesOnChange;
    }

    public void setUpdateValuesOnChange(boolean updateValuesOnChange) {
        this.updateValuesOnChange = updateValuesOnChange;
    }

    public String patchSeriesPlaceholderInValue(@Nullable String value, @Nonnull Map<String, String> seriesProperties) {
        return value;
    }

    public String patchResultPlaceholderInValue(@Nullable String value, @Nonnull List<JobResultContainer> results) {
        return value;
    }

    protected final String replaceSeriesPlaceholders(String value, Map<String, String> properties) {
        if (StringFunctions.isEmpty((String)value)) {
            return value;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String string = entry.getValue();
            if (string == null) {
                string = "";
            }
            value = value.replace("{" + entry.getKey() + "}", string);
        }
        return value;
    }
}

