/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action.print;

import com.inet.annotations.InternalApi;
import com.inet.taskplanner.server.api.action.print.PrinterDescription;
import com.inet.taskplanner.server.api.action.print.PrinterProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

@InternalApi
public class PrinterProviderDefaultImpl
implements PrinterProvider {
    private static List<PrinterDescription> ai = Collections.emptyList();

    @Override
    public List<PrinterDescription> availablePrinters() {
        ForkJoinPool.commonPool().execute(() -> {
            ArrayList<PrinterDescription> arrayList = new ArrayList<PrinterDescription>();
            for (PrintService printService : PrintServiceLookup.lookupPrintServices(null, null)) {
                arrayList.add(new PrinterDescription(printService));
            }
            ai = arrayList;
        });
        return ai;
    }

    @Override
    public PrinterDescription getPrinterForName(String printer) {
        Optional<PrinterDescription> optional = this.availablePrinters().stream().filter(printerDescription -> printerDescription.getService().getName().equals(printer)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    static {
        new PrinterProviderDefaultImpl().availablePrinters();
    }
}

