/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action.email;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.action.email.b;
import com.inet.taskplanner.server.api.action.email.c;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.DisableCondition;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FilenameField;
import com.inet.taskplanner.server.api.field.HtmlTextAreaField;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.field.VisibleCondition;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class EmailResultActionFactory
extends ResultActionFactory<c> {
    public static final String EXTENSION_NAME = "result.email";
    public static final String PROP_SUBJECT = "prop_subject";
    public static final String PROP_PLAINTEXT = "prop_plaintext";
    public static final String PROP_MESSAGE = "prop_message";
    public static final String PROP_RECEIVER = "prop_receiver";
    public static final String PROP_CC = "prop_cc";
    public static final String PROP_BCC = "prop_bcc";
    public static final String PROP_ATTACH_FILES = "prop_attach_files";
    public static final String PROPERTY_FILENAME_FORMAT = "filenameformat";
    public static final String PROP_SENDER = "prop_sender";
    private static final Pattern S = Pattern.compile("\\{[^}]*\\}");

    public EmailResultActionFactory() {
        super(EXTENSION_NAME);
    }

    @Override
    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("result.email.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("result.email.description", new Object[0]);
        URL uRL = this.getClass().getResource("/com/inet/taskplanner/server/api/action/email/email.png");
        String string3 = "taskplanner.action.email";
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.add(new TextField(PROP_RECEIVER, TaskPlannerServerPlugin.MSG.getMsg("result.email.recipient", new Object[0])));
        arrayList.add(new TextField(PROP_CC, TaskPlannerServerPlugin.MSG.getMsg("result.email.cc", new Object[0])));
        arrayList.add(new TextField(PROP_BCC, TaskPlannerServerPlugin.MSG.getMsg("result.email.bcc", new Object[0])));
        TextField textField = new TextField(PROP_SENDER, TaskPlannerServerPlugin.MSG.getMsg("result.email.sender", new Object[0]));
        textField.setPlaceholder(b.f());
        arrayList.add(textField);
        arrayList.add(new TextField(PROP_SUBJECT, TaskPlannerServerPlugin.MSG.getMsg("result.email.subject", new Object[0])));
        BooleanField booleanField = new BooleanField(PROP_PLAINTEXT, TaskPlannerServerPlugin.MSG.getMsg("result.email.plaintext", new Object[0]));
        booleanField.setValue("false");
        arrayList.add(booleanField);
        TextAreaField textAreaField = new TextAreaField(PROP_MESSAGE, TaskPlannerServerPlugin.MSG.getMsg("result.email.message", new Object[0]));
        ArrayList<FieldCondition> arrayList2 = new ArrayList<FieldCondition>();
        FieldCondition fieldCondition = VisibleCondition.visible(booleanField, FieldCondition.OP.equals, "true");
        arrayList2.add(fieldCondition);
        textAreaField.setConditions(arrayList2);
        textAreaField.setValue("[jobresult]");
        arrayList.add(textAreaField);
        HtmlTextAreaField htmlTextAreaField = new HtmlTextAreaField(PROP_MESSAGE, TaskPlannerServerPlugin.MSG.getMsg("result.email.message", new Object[0]));
        ArrayList<FieldCondition> arrayList3 = new ArrayList<FieldCondition>();
        FieldCondition fieldCondition2 = VisibleCondition.visible(booleanField, FieldCondition.OP.equals, "false");
        arrayList3.add(fieldCondition2);
        htmlTextAreaField.setConditions(arrayList3);
        arrayList.add(htmlTextAreaField);
        BooleanField booleanField2 = new BooleanField(PROP_ATTACH_FILES, TaskPlannerServerPlugin.MSG.getMsg("result.email.attach_files", new Object[0]));
        arrayList.add(booleanField2);
        FilenameField filenameField = new FilenameField(PROPERTY_FILENAME_FORMAT, TaskPlannerServerPlugin.MSG.getMsg("result.email.filenameformat", new Object[0]));
        filenameField.setValue("[filename]");
        ArrayList<FieldCondition> arrayList4 = new ArrayList<FieldCondition>();
        arrayList4.add(DisableCondition.disabled(booleanField2, FieldCondition.OP.notequal, "true"));
        filenameField.setConditions(arrayList4);
        arrayList.add(filenameField);
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList5.add("jobresult");
        arrayList5.add("filename");
        arrayList5.add("date");
        arrayList5.add("time");
        return new ResultActionInfo(this.getExtensionName(), string, string2, uRL, string3, arrayList, arrayList5);
    }

    @Override
    public void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = definition.getProperty(PROP_SUBJECT);
        String string4 = definition.getProperty(PROP_MESSAGE);
        String string5 = definition.getProperty(PROP_RECEIVER);
        String string6 = definition.getProperty(PROPERTY_FILENAME_FORMAT);
        this.a(string3, arrayList, () -> TaskPlannerServerPlugin.MSG.getMsg("result.email.error.noSubject", new Object[0]));
        this.a(string4, arrayList, () -> TaskPlannerServerPlugin.MSG.getMsg("result.email.error.noMessage", new Object[0]));
        this.a(string5, arrayList, () -> TaskPlannerServerPlugin.MSG.getMsg("result.email.error.noReceiver", new Object[0]));
        if (!this.hasPlaceholderSet(string5, taskID)) {
            this.a(string5, arrayList);
        }
        if ((string2 = definition.getProperty(PROP_CC)) != null && !string2.isBlank() && !this.hasPlaceholderSet(string2, taskID)) {
            this.a(string2, arrayList);
        }
        if ((string = definition.getProperty(PROP_BCC)) != null && !string.isBlank() && !this.hasPlaceholderSet(string, taskID)) {
            this.a(string, arrayList);
        }
        if (Boolean.parseBoolean(definition.getProperty(PROP_ATTACH_FILES))) {
            this.a(string6, arrayList, () -> TaskPlannerServerPlugin.MSG.getMsg("result.email.error.nofilenameformat", new Object[0]));
        }
        if (!arrayList.isEmpty()) {
            throw new ValidationException(arrayList);
        }
    }

    private void a(String string, List<String> list, Supplier<String> supplier) {
        if (string == null || string.trim().isEmpty()) {
            list.add(supplier.get());
        }
    }

    private void a(String string, List<String> list) {
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                String string3 = string2.trim();
                if (S.matcher(string3).find()) continue;
                try {
                    new InternetAddress(string3, true);
                }
                catch (AddressException addressException) {
                    TaskPlannerServerPlugin.LOGGER.debug((Object)addressException);
                    list.add(TaskPlannerServerPlugin.MSG.getMsg("result.email.error.notValidAddress", new Object[]{StringFunctions.encodeHTML((String)string3, (boolean)false), StringFunctions.encodeHTML((String)addressException.getMessage(), (boolean)false)}));
                }
            }
        }
    }

    @Override
    protected c createInstanceFrom(@Nullable ResultActionDefinition definition, @Nullable GUID taskID) {
        String string = definition.getProperty(PROP_SUBJECT);
        String string2 = definition.getProperty(PROP_MESSAGE);
        String string3 = definition.getProperty(PROP_RECEIVER);
        String string4 = definition.getProperty(PROP_CC);
        String string5 = definition.getProperty(PROP_BCC);
        String string6 = definition.getProperty(PROP_ATTACH_FILES);
        String string7 = definition.getProperty(PROPERTY_FILENAME_FORMAT);
        String string8 = definition.getProperty(PROP_SENDER);
        boolean bl = Boolean.valueOf(definition.getProperty(PROP_PLAINTEXT)) == false;
        return new c(string, string2, string3, string4, string5, Boolean.parseBoolean(string6), string7, string8, bl);
    }

    @Override
    public SummaryInfo getSummary(@Nullable ResultActionDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("result.email.recipient", new Object[0]), definition.getProperty(PROP_RECEIVER)));
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("result.email.cc", new Object[0]), definition.getProperty(PROP_CC)));
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("result.email.bcc", new Object[0]), definition.getProperty(PROP_BCC)));
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("result.email.subject", new Object[0]), definition.getProperty(PROP_SUBJECT)));
        return new SummaryInfo(arrayList);
    }

    @Override
    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        if (definition == null) {
            return Arrays.asList(ResultFlavor.FILE, ResultFlavor.NONE, ResultFlavor.TEXT);
        }
        ArrayList<ResultFlavor> arrayList = new ArrayList<ResultFlavor>();
        arrayList.add(ResultFlavor.NONE);
        String string = definition.getProperty(PROP_MESSAGE);
        if (Boolean.parseBoolean(definition.getProperty(PROP_ATTACH_FILES))) {
            arrayList.add(ResultFlavor.FILE);
        }
        if (string != null && string.contains("[jobresult]")) {
            arrayList.add(ResultFlavor.TEXT);
        }
        return arrayList;
    }

    @Override
    public boolean isAutoResolvePlaceholders() {
        return false;
    }

    @Override
    protected ResultActionDefinition patchDefinitionProperties(@Nonnull ResultActionDefinition baseDefinition, @Nonnull Map<String, String> seriesProperties, @Nullable GUID taskID) {
        ResultActionDefinition resultActionDefinition = super.patchDefinitionProperties(baseDefinition, seriesProperties, taskID);
        String string = resultActionDefinition.getProperty(PROP_MESSAGE);
        if (string != null) {
            string = new PlaceholderResolver(string).withPlaceHolderCharacters("{", "}").addMetaData(seriesProperties).resolve();
            string = new PlaceholderResolver(string).addMetaData(seriesProperties).resolve();
            resultActionDefinition.setProperty(PROP_MESSAGE, string);
        }
        return resultActionDefinition;
    }
}

