/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.event.TaskEventListener;
import com.inet.taskplanner.server.internal.InternalTask;
import com.inet.taskplanner.server.internal.f;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class TaskPlanner {
    private static TaskPlanner m;
    public static final Permission PERMISSION_TASKPLANNER;
    public static final Permission PERMISSION_TASKPLANNER_ADMIN;

    private TaskPlanner() {
    }

    public static synchronized TaskPlanner getInstance() {
        if (m == null) {
            m = new TaskPlanner();
        }
        return m;
    }

    public void registerEventListener(@Nonnull TaskEventListener listener) {
        f.M().registerEventListener(listener);
    }

    public void unregisterEventListener(@Nonnull TaskEventListener listener) {
        try {
            f.M().unregisterEventListener(listener);
        }
        catch (IllegalStateException illegalStateException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)illegalStateException);
        }
    }

    @Nullable
    public TaskExecution getTaskExecution(@Nonnull GUID taskID) {
        return f.M().getTaskExecution(taskID);
    }

    @Nullable
    public TaskDefinition getTaskDefinition(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        return internalTask != null ? internalTask.getModel().copyTaskModel() : null;
    }

    @Nonnull
    public List<GUID> getUserTaskIDs(GUID userId) {
        return f.M().getUserTaskIDs(userId);
    }

    @Nonnull
    public List<GUID> getAllTaskIDs() {
        return f.M().getAllTaskIDs();
    }

    @Nullable
    public CompletableFuture<Void> executeTask(@Nonnull GUID taskID) {
        return this.executeTask(taskID, Collections.emptyMap());
    }

    @Nullable
    public CompletableFuture<Void> executeTask(@Nonnull GUID taskID, @Nullable Map<String, String> placeholders) {
        InternalTask internalTask = f.M().h(taskID);
        if (internalTask == null) {
            return null;
        }
        return f.M().a(internalTask, true, placeholders);
    }

    public CompletableFuture<Void> executeTask(@Nonnull TaskDefinition task, @Nonnull GUID userId) {
        return f.M().executeTask(task, userId);
    }

    @Nonnull
    public GUID addTask(@Nonnull TaskDefinition task, @Nonnull GUID userId) {
        return f.M().addTask(task, userId);
    }

    public void updateTask(@Nonnull GUID taskID, @Nonnull TaskDefinition taskModel) {
        f.M().updateTask(taskID, taskModel);
    }

    public void removeTask(@Nonnull GUID taskID) {
        f.M().removeTask(taskID);
    }

    public void activateTask(@Nonnull GUID taskID) {
        f.M().activateTask(taskID);
    }

    public void deactivateTask(@Nonnull GUID taskID) {
        f.M().deactivateTask(taskID);
    }

    public void cancelTask(@Nonnull GUID taskID, boolean waitForCancelation) {
        f.M().cancelTask(taskID, waitForCancelation);
    }

    public void cancelTaskExecution(@Nonnull GUID taskID, @Nullable GUID executionID, boolean waitForCancelation) {
        f.M().cancelTaskExecution(taskID, executionID, waitForCancelation);
    }

    static {
        Permission.createCategory((String)"taskplanner", (int)3000, TaskPlannerServerPlugin.class);
        PERMISSION_TASKPLANNER = SystemPermissionManager.add((String)"taskplanner", (String)"taskplanner", null, (int)6700, (boolean)true, TaskPlannerServerPlugin.class);
        PERMISSION_TASKPLANNER_ADMIN = SystemPermissionManager.add((String)"taskplanner.admin", (String)"taskplanner", (String)"taskplanner", (int)6750, (boolean)true, TaskPlannerServerPlugin.class);
    }
}

