/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler;

import com.inet.cache.CacheTimeoutListener;
import com.inet.cache.MemoryStoreMap;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.internalapi.TaskPlannerForUsers;
import com.inet.taskplanner.webapi.handler.guid.viewtask.TaskDescription;
import com.inet.usersandgroups.api.user.UserAccountScope;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Description(description="Directly run a task planner task, defined using JSON. There is no trigger required, the jobs and actions will be executed.", summary="Directly run a task")
public class a
extends RequestHandler<TaskDescription, GUID> {
    private static final MemoryStoreMap<GUID, TaskDefinition> cO = new MemoryStoreMap(60, true);

    public a() {
        super(new String[]{"execute"});
    }

    @Operation(summary="Execute Task", description="Schedules execution of a specified task. Returns the GUID of the executed task.", requestBody=@RequestBody(description="JSON body containing task details to be executed.", required=true, content={@Content(schema=@Schema(implementation=TaskDescription.class))}), responses={@ApiResponse(responseCode="200", description="Task executed successfully", content={@Content(schema=@Schema(implementation=GUID.class), examples={@ExampleObject(name="GUID", summary="A Single GUID", value="b6nmv97sutmnvhtw8hen0yh7y")})}), @ApiResponse(responseCode="500", description="A task was not given or misconfigured.")})
    @ApiResponse(responseCode="500", description="A task was not given or misconfigured.")
    public GUID a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable TaskDescription taskDescription, boolean bl) throws IOException {
        TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
        if (taskDescription == null) {
            throw new ClientMessageException(TaskPlannerServerPlugin.MSG.getMsg("noContentSet", new Object[]{TaskPlannerServerPlugin.MSG.getMsg("noContentSet.execute", new Object[0])}));
        }
        GUID gUID = taskDescription.getNonNullTaskId();
        if (!bl) {
            TaskDefinition taskDefinition = TaskDescription.toTask(taskDescription);
            if (StringFunctions.isEmpty((String)taskDefinition.getName())) {
                taskDefinition.setName(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.webapi.defaultImportName", new Object[0]));
            }
            gUID = taskPlannerForUsers.addTask(taskDefinition);
            cO.put((Object)gUID, (Object)taskDefinition);
            taskPlannerForUsers.executeTask(taskDefinition);
        }
        return gUID;
    }

    public String getHelpPageKey() {
        return "taskplanner-webapi.execute";
    }

    public static void o(@Nullable GUID gUID) {
        if (gUID != null) {
            cO.get((Object)gUID);
        }
    }

    @Operation(summary="Execute Task", description="Schedules execution of a specified task. Returns the GUID of the executed task.", requestBody=@RequestBody(description="JSON body containing task details to be executed.", required=true, content={@Content(schema=@Schema(implementation=TaskDescription.class))}), responses={@ApiResponse(responseCode="200", description="Task executed successfully", content={@Content(schema=@Schema(implementation=GUID.class), examples={@ExampleObject(name="GUID", summary="A Single GUID", value="b6nmv97sutmnvhtw8hen0yh7y")})}), @ApiResponse(responseCode="500", description="A task was not given or misconfigured.")})
    @ApiResponse(responseCode="500", description="A task was not given or misconfigured.")
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (TaskDescription)object, bl);
    }

    static {
        cO.addTimeoutListener((CacheTimeoutListener)new CacheTimeoutListener<GUID, TaskDefinition>(){

            public void a(GUID gUID, TaskDefinition taskDefinition) {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    TaskPlannerForUsers.getInstance().removeTask(gUID);
                }
            }

            public /* synthetic */ void timeout(Object object, Object object2) {
                this.a((GUID)object, (TaskDefinition)object2);
            }
        });
        ShutdownManager.add((ShutdownFinalizer)new ShutdownFinalizer(){

            public void onShutdown() {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
                    for (Map.Entry entry : cO.entrySet()) {
                        taskPlannerForUsers.removeTask((GUID)entry.getKey());
                    }
                }
            }

            public int order() {
                return Integer.MIN_VALUE;
            }
        });
    }
}

