/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.time;

import com.inet.http.servlet.ClientLocale;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.MonthlyDay;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.taskplanner.server.api.trigger.time.TimeTriggerForCustomSettings;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.Locale;
import javax.annotation.Nonnull;

public class a
extends com.inet.taskplanner.server.api.trigger.cron.a
implements Trigger {
    private ZonedDateTime bA;
    private boolean bB;
    private ZonedDateTime bC;

    public a(TriggerDefinition triggerDefinition) {
        super(a.b(triggerDefinition));
        this.bA = a.a(triggerDefinition);
        String string = triggerDefinition.getProperty("repeat.select");
        boolean bl = this.bB = string != null && RepeatInterval.valueOf(string) == RepeatInterval.TWOWEEKS;
        if (this.bB) {
            this.bC = a.c(triggerDefinition);
        }
    }

    public static boolean a(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
        Duration duration = Duration.between(zonedDateTime.toLocalDate().atStartOfDay(), zonedDateTime2.toLocalDate().atStartOfDay());
        long l2 = duration.getSeconds() / 60L / 60L / 24L / 7L;
        return l2 % 2L == 0L;
    }

    @Override
    protected void triggerAction() {
        if (this.bB && !a.a(ZonedDateTime.now(), this.bC)) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)"Do not trigger 2-weekly because is not correct week");
            return;
        }
        super.triggerAction();
    }

    @Override
    protected ZonedDateTime r() {
        return this.bA;
    }

    @Nonnull
    public static ZonedDateTime a(TriggerDefinition triggerDefinition) {
        ZonedDateTime zonedDateTime = a.c(triggerDefinition);
        zonedDateTime = zonedDateTime.isBefore(ZonedDateTime.now()) ? ZonedDateTime.now() : zonedDateTime.minusMinutes(1L);
        return zonedDateTime;
    }

    @Nonnull
    public static String b(@Nonnull TriggerDefinition triggerDefinition) {
        ZonedDateTime zonedDateTime = a.c(triggerDefinition);
        String string = triggerDefinition.getProperty("repeat.select");
        RepeatInterval repeatInterval = string == null ? RepeatInterval.NONE : RepeatInterval.valueOf(string);
        switch (repeatInterval) {
            case DAILY: {
                return String.format("%d %d * * ?", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
            case WEEKLY: 
            case TWOWEEKS: {
                return String.format("%d %d ? * %d", zonedDateTime.getMinute(), zonedDateTime.getHour(), a.a(zonedDateTime.getDayOfWeek()));
            }
            case WORKDAYS: {
                return String.format("%d %d ? * MON-FRI", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
            case MONTHLY: {
                return a.a(triggerDefinition, zonedDateTime);
            }
            case QUARTERLY: {
                return String.format("%d %d %d %d/3 ?", zonedDateTime.getMinute(), zonedDateTime.getHour(), zonedDateTime.getDayOfMonth(), a.b(zonedDateTime.getMonthValue()));
            }
            case YEARLY: {
                return String.format("%d %d %d %d ?", zonedDateTime.getMinute(), zonedDateTime.getHour(), zonedDateTime.getDayOfMonth(), zonedDateTime.getMonthValue());
            }
            case NONE: {
                return String.format("%d %d %d %d ? %d", zonedDateTime.getMinute(), zonedDateTime.getHour(), zonedDateTime.getDayOfMonth(), zonedDateTime.getMonthValue(), zonedDateTime.getYear());
            }
        }
        throw new IllegalArgumentException(repeatInterval.name());
    }

    private static int b(int n2) {
        while (n2 > 3) {
            n2 -= 3;
        }
        return n2;
    }

    @Nonnull
    private static String a(TriggerDefinition triggerDefinition, ZonedDateTime zonedDateTime) {
        String string = triggerDefinition.getProperty("which.select");
        MonthlyDay monthlyDay = string == null ? MonthlyDay.INITIAL : MonthlyDay.valueOf(string);
        switch (monthlyDay) {
            case FIRST: {
                return String.format("%d %d 1 * ?", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
            case SECOND: {
                return String.format("%d %d 2 * ?", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
            case THIRD: {
                return String.format("%d %d 3 * ?", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
            case FOURTH: {
                return String.format("%d %d 4 * ?", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
            case LAST: {
                return String.format("%d %d L * ?", zonedDateTime.getMinute(), zonedDateTime.getHour());
            }
        }
        return String.format("%d %d %d * ?", zonedDateTime.getMinute(), zonedDateTime.getHour(), zonedDateTime.getDayOfMonth());
    }

    private static int a(DayOfWeek dayOfWeek) {
        int n2 = dayOfWeek.getValue() + 1;
        return n2 > 7 ? 1 : n2;
    }

    @Nonnull
    public static ZonedDateTime c(TriggerDefinition triggerDefinition) {
        String string = triggerDefinition.getProperty("start.day");
        String string2 = triggerDefinition.getProperty("start.time");
        try {
            long l2 = Long.parseLong(string);
            long l3 = Long.parseLong(string2);
            LocalDate localDate = LocalDateTime.ofInstant(Instant.ofEpochSecond(l2 / 1000L), ZoneId.systemDefault()).toLocalDate();
            LocalTime localTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(l3 / 1000L), ZoneId.systemDefault()).toLocalTime();
            return ZonedDateTime.now().with(localTime).with(localDate).withSecond(0).withNano(0);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new IllegalArgumentException(String.format("Start day and time are invalid: date=%s, time=%s", string, string2), dateTimeParseException);
        }
    }

    @Nonnull
    public static String d(@Nonnull TriggerDefinition triggerDefinition) {
        ZonedDateTime zonedDateTime = a.c(triggerDefinition);
        String string = triggerDefinition.getProperty("repeat.select");
        RepeatInterval repeatInterval = string == null ? RepeatInterval.NONE : RepeatInterval.valueOf(string);
        Locale locale = ClientLocale.getThreadLocale();
        String string2 = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale).format(zonedDateTime);
        switch (repeatInterval) {
            case DAILY: {
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.daily", new Object[]{string2});
            }
            case WEEKLY: {
                String string3 = DateTimeFormatter.ofPattern("EEEE", locale).format(zonedDateTime);
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.weekly", new Object[]{string2, string3});
            }
            case TWOWEEKS: {
                String string4 = DateTimeFormatter.ofPattern("EEEE", locale).format(zonedDateTime);
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.twoweeks", new Object[]{string2, string4});
            }
            case WORKDAYS: {
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.workday", new Object[]{string2});
            }
            case MONTHLY: {
                return a.a(triggerDefinition, zonedDateTime, string2);
            }
            case QUARTERLY: {
                String string5 = a.c((zonedDateTime.getMonthValue() - 1) % 3 + 1);
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.quarterly", new Object[]{string2, string5, a.c(zonedDateTime.getDayOfMonth())});
            }
            case YEARLY: {
                return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.yearly", new Object[]{string2, a.a(zonedDateTime)});
            }
            case CUSTOM: {
                return TimeTriggerForCustomSettings.generateNiceReadableSentenceForExecution(zonedDateTime, string2, triggerDefinition);
            }
        }
        String string6 = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale).format(zonedDateTime);
        return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.once", new Object[]{string2, string6});
    }

    private static String c(int n2) {
        return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.nthPattern", new Object[]{n2});
    }

    private static String a(ZonedDateTime zonedDateTime) {
        Locale locale = ClientLocale.getThreadLocale();
        Object object = ((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern().replaceAll("[^\\p{Alpha}]*y+[^\\p{Alpha}]*", "");
        if (locale.getLanguage().equals(Locale.GERMAN.getLanguage())) {
            object = (String)object + ".";
        }
        return DateTimeFormatter.ofPattern((String)object, locale).format(zonedDateTime);
    }

    private static String a(TriggerDefinition triggerDefinition, ZonedDateTime zonedDateTime, String string) {
        String string2 = triggerDefinition.getProperty("which.select");
        MonthlyDay monthlyDay = string2 == null ? MonthlyDay.INITIAL : MonthlyDay.valueOf(string2);
        return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.monthly", new Object[]{string, switch (monthlyDay) {
            case MonthlyDay.FIRST -> 1;
            case MonthlyDay.SECOND -> 2;
            case MonthlyDay.THIRD -> 3;
            case MonthlyDay.FOURTH -> 4;
            case MonthlyDay.LAST -> 0;
            default -> zonedDateTime.getDayOfMonth();
        }});
    }
}

