/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.MonthlyDay;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;

@PublicApi
public class TimeTriggerBuilder {
    private ZonedDateTime aS = ZonedDateTime.now();
    private RepeatInterval aT = RepeatInterval.NONE;
    private MonthlyDay aU = MonthlyDay.INITIAL;

    public TimeTriggerBuilder withStartDate(@Nonnull ZonedDateTime startDateAndTime) {
        if (startDateAndTime == null) {
            throw new IllegalArgumentException("startDateAndTime cannot be null!");
        }
        this.aS = startDateAndTime;
        return this;
    }

    public TimeTriggerBuilder withHourAndMinute(int hour, int minute) throws DateTimeException {
        this.aS = this.aS.withHour(hour).withMinute(minute);
        return this;
    }

    public TimeTriggerBuilder withRepeating(@Nonnull RepeatInterval repeatInterval) {
        if (repeatInterval == null) {
            throw new IllegalArgumentException("repeatInterval cannot be null!");
        }
        this.aT = repeatInterval;
        return this;
    }

    public TimeTriggerBuilder withMonthlyDay(@Nonnull MonthlyDay monthlyDay) {
        if (monthlyDay == null) {
            throw new IllegalArgumentException("monthlyDay cannot be null!");
        }
        this.aU = monthlyDay;
        return this;
    }

    public TriggerDefinition create() {
        TriggerDefinition triggerDefinition = new TriggerDefinition("trigger.time");
        triggerDefinition.setProperty("repeat.select", this.aT.name());
        triggerDefinition.setProperty("start.day", String.valueOf(this.aS.toEpochSecond() * 1000L));
        triggerDefinition.setProperty("start.time", String.valueOf(this.aS.toEpochSecond() * 1000L));
        triggerDefinition.setProperty("which.select", this.aU.name());
        return triggerDefinition;
    }
}

