/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.result;

import com.inet.annotations.PublicApi;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class ByteArrayFileResult
implements FileResult {
    private final String name;
    private final byte[] ax;

    public ByteArrayFileResult(String name, byte[] data) {
        if (name == null || data == null) {
            throw new IllegalArgumentException("Parameters are null");
        }
        this.name = name;
        this.ax = data;
    }

    @Override
    @Nonnull
    public List<ResultFlavor> getFlavors() {
        return Arrays.asList(ResultFlavor.FILE);
    }

    @Override
    @Nonnull
    public String getFileName() {
        return this.name;
    }

    @Override
    public long getFileSize() {
        return this.ax.length;
    }

    @Override
    @Nonnull
    public InputStream getFileContent() throws IOException {
        return new FastByteArrayInputStream(this.ax);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getFileContentType() throws IOException {
        return MimeTypes.getMimeType((String)this.name);
    }
}

