/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.lib.util.Encryption;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldType;
import java.io.IOException;
import javax.annotation.SuppressFBWarnings;

@JsonData
@PublicApi
public class PasswordField
extends Field {
    private boolean asTextArea;
    private String placeholderIfValueSet;

    public PasswordField(String key, String label) {
        super(FieldType.PASSWORD, key, label);
    }

    public static PasswordField passwordFieldAsTextArea(String key, String label, String placeholderIfValueSet) {
        PasswordField passwordField = new PasswordField(key, label);
        passwordField.placeholderIfValueSet = placeholderIfValueSet;
        passwordField.asTextArea = true;
        return passwordField;
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "PADDING_ORACLE"}, justification="Password is not stored in plain text.")
    public static String encodePassword(String plainPassword) throws IOException {
        return Encryption.encodePassword((String)plainPassword);
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "PADDING_ORACLE"}, justification="Password is not stored in plain text.")
    public static String decodePassword(String encodedPassword) throws IOException {
        return Encryption.decodePassword((String)encodedPassword);
    }
}

