/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldType;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.List;
import java.util.Map;

@JsonData
@PublicApi
public class FloatField
extends Field {
    private List<UnitConfigProperty.Unit> units;

    public FloatField(String key, String label) {
        super(FieldType.FLOAT_NUMBER, key, label);
    }

    public FloatField(String key, String label, List<UnitConfigProperty.Unit> units) {
        super(FieldType.UNIT_FLOAT_NUMBER, key, label);
        this.units = units;
    }

    public static boolean isValidValue(String value) {
        try {
            return value.matches("^\\[[^\\]]+?\\]$") || Float.valueOf(value) != null;
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return false;
        }
    }

    @Override
    public String patchResultPlaceholderInValue(String value, List<JobResultContainer> results) {
        if (value == null) {
            return value;
        }
        return new PlaceholderResolver(value).addMetaData(results).resolve();
    }

    @Override
    public String patchSeriesPlaceholderInValue(String value, Map<String, String> seriesProperties) {
        return this.replaceSeriesPlaceholders(value, seriesProperties);
    }
}

