/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.logging.LogManager;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldType;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
@PublicApi
public class CurrencyField
extends Field {
    private String symbol = CurrencyField.getCurrency().getSymbol();

    public CurrencyField(String key, String label) {
        super(FieldType.CURRENCY, key, label);
    }

    public static boolean isValidValue(String value) {
        try {
            return value.matches("^\\[[^\\]]+?\\]$") || Float.valueOf(value) != null;
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return false;
        }
    }

    @Nonnull
    private static Currency getCurrency() {
        Locale locale = Locale.getDefault();
        Currency currency = null;
        try {
            currency = Currency.getInstance(locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogManager.getApplicationLogger().debug((Object)("Cannot load correct currency for locale " + locale.toString()));
        }
        if (currency == null) {
            return Currency.getInstance(Locale.US);
        }
        return currency;
    }

    @Override
    public String patchResultPlaceholderInValue(String value, List<JobResultContainer> results) {
        if (value == null) {
            return value;
        }
        return new PlaceholderResolver(value).addMetaData(results).resolve();
    }

    @Override
    public String patchSeriesPlaceholderInValue(String value, Map<String, String> seriesProperties) {
        return this.replaceSeriesPlaceholders(value, seriesProperties);
    }
}

