/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.common;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.plugin.NamedExtension;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.AbstractInfo;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class AbstractFactory<COMPONENT, DEFINITION extends AbstractDefinition<DEFINITION>, INFO extends AbstractInfo, SUMMARY extends SummaryInfo>
implements NamedExtension {
    private String extensionName;

    public AbstractFactory(String extensionName) {
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name must not be null");
        }
        this.extensionName = extensionName;
    }

    public final String getExtensionName() {
        return this.extensionName;
    }

    protected final void checkDefinitionArgument(DEFINITION definition) {
        if (definition == null) {
            throw new IllegalArgumentException("definition must not be null");
        }
        if (!this.getExtensionName().equals(((AbstractDefinition)definition).getExtensionName())) {
            String string = String.format("extension name of the definition \"%s\" does not match extension name of the factory \"%s\"", ((AbstractDefinition)definition).getExtensionName(), this.getExtensionName());
            throw new IllegalArgumentException(string);
        }
    }

    public abstract INFO getInformation(@Nullable GUID var1);

    protected abstract void validate(@Nonnull DEFINITION var1, @Nullable GUID var2) throws ValidationException;

    @Deprecated
    protected COMPONENT createInstanceFrom(@Nonnull DEFINITION definition) {
        throw new IllegalStateException("The method 'createInstanceFrom( @Nonnull DEFINITION definition, GUID taskID )' should be implemented instead.");
    }

    protected COMPONENT createInstanceFrom(@Nonnull DEFINITION definition, @Nullable GUID taskID) {
        LogManager.deprecatedMessage();
        return this.createInstanceFrom(definition);
    }

    public abstract SUMMARY getSummary(@Nonnull DEFINITION var1);

    public boolean isAvailable() {
        return true;
    }
}

