/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler;

import com.inet.id.GUID;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.internalapi.TaskPlannerForUsers;
import com.inet.taskplanner.server.internalapi.TaskShortDescription;
import com.inet.taskplanner.webapi.handler.guid.viewtask.TaskDescription;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Description(description="Export tasks that belong to the user. May also be called with an /all parameter to export all tasks, if the user has the appropriate permissions", summary="Export tasks of the user")
public class b
extends RequestHandler<Void, List<TaskDescription>> {
    private boolean cP;

    public b(boolean bl) {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "export";
            stringArray = stringArray2;
            stringArray2[1] = "all";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "export";
        }
        super(stringArray);
        this.cP = bl;
    }

    @Operation(summary="Export Tasks", description="Exports tasks that belong to the user. May also export all tasks if the user has the appropriate permissions.", responses={@ApiResponse(responseCode="200", description="Tasks exported successfully", content={@Content(schema=@Schema(implementation=TaskDescription[].class), examples={@ExampleObject(name="Task List", summary="A List of Task Descriptions", value="[{\"taskId\":\"b6nmv97sutmnvhtw8hen0yh7y\",\"taskName\":\"Sample Task\"}]")})}), @ApiResponse(responseCode="403", description="User does not have permission to export tasks.")})
    public List<TaskDescription> a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl) throws IOException {
        TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
        List<TaskShortDescription> list = null;
        list = this.cP ? taskPlannerForUsers.listAllTasks() : taskPlannerForUsers.listUserTasks();
        Collections.sort(list, (taskShortDescription, taskShortDescription2) -> taskShortDescription.getId().compareTo(taskShortDescription2.getId()));
        ArrayList<TaskDescription> arrayList = new ArrayList<TaskDescription>();
        for (TaskShortDescription taskShortDescription3 : list) {
            GUID gUID = GUID.valueOf((String)taskShortDescription3.getId());
            if (gUID == null) continue;
            TaskDefinition taskDefinition = taskPlannerForUsers.getTaskDefinition(gUID);
            TaskExecution taskExecution = taskPlannerForUsers.getTaskExecution(gUID);
            if (taskDefinition == null || taskExecution == null) continue;
            arrayList.add(TaskDescription.from(taskDefinition, taskExecution));
        }
        return arrayList;
    }

    public String getHelpPageKey() {
        return this.cP ? "taskplanner-webapi.exportall" : "taskplanner-webapi.export";
    }

    @Operation(summary="Export Tasks", description="Exports tasks that belong to the user. May also export all tasks if the user has the appropriate permissions.", responses={@ApiResponse(responseCode="200", description="Tasks exported successfully", content={@Content(schema=@Schema(implementation=TaskDescription[].class), examples={@ExampleObject(name="Task List", summary="A List of Task Descriptions", value="[{\"taskId\":\"b6nmv97sutmnvhtw8hen0yh7y\",\"taskName\":\"Sample Task\"}]")})}), @ApiResponse(responseCode="403", description="User does not have permission to export tasks.")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, bl);
    }
}

