/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.time;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.time.AbstractTimeTrigger;
import com.inet.taskplanner.server.api.trigger.time.MonthlyDay;
import com.inet.taskplanner.server.api.trigger.time.a;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@PublicApi
public class TimeTriggerForCustomSettings
extends AbstractTimeTrigger {
    public static final String PROP_CUSTOM_INTERVALTYPE = "custom.intervaltype";
    public static final int INTERVALTYPE_DAILY = 1;
    public static final int INTERVALTYPE_WEEKLY = 2;
    public static final int INTERVALTYPE_MONTHLY = 3;
    public static final String PROP_CUSTOM_INTERVAL = "custom.interval";
    public static final String PROP_CUSTOM_WEEKLY_DAYOFWEEK = "custom.weekly.dayofweek";
    public static final String PROP_CUSTOM_MONTHLY_CARDINALITY = "custom.monthly.cardinality";
    public static final String PROP_CUSTOM_MONTHLY_DAY_OF_MONTH = "custom.monthly.day";
    public static final int CUSTOM_MONTHLY_DAY_DAY = 8;
    public static final int CUSTOM_MONTHLY_DAY_WEEKDAY = 9;
    private TriggerDefinition bF;

    public TimeTriggerForCustomSettings(TriggerDefinition definition) {
        this.bF = definition.copyDefinition();
    }

    @Override
    protected Optional<ZonedDateTime> calculateNextExecutionTime(ZonedDateTime lastExecutiontime) {
        List<ZonedDateTime> list = TimeTriggerForCustomSettings.a(this.bF, lastExecutiontime, 1);
        return Optional.ofNullable(list.isEmpty() ? null : list.get(0));
    }

    @Override
    protected String getTriggerDescribingStringForLog() {
        return "Custom time interval: " + String.valueOf(this.bF.getProperties());
    }

    private static List<ZonedDateTime> a(TriggerDefinition triggerDefinition, @Nullable ZonedDateTime zonedDateTime, int n2) {
        ArrayList<ZonedDateTime> arrayList = new ArrayList<ZonedDateTime>(n2);
        try {
            MonthlyDay monthlyDay;
            ZonedDateTime zonedDateTime2 = a.c(triggerDefinition);
            ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
            ZonedDateTime zonedDateTime4 = null;
            int n3 = Integer.parseInt(triggerDefinition.getProperty(PROP_CUSTOM_INTERVALTYPE));
            String string = triggerDefinition.getProperty(PROP_CUSTOM_INTERVAL);
            int n4 = string == null ? 0 : Math.max(Integer.parseInt(string), 1);
            String string2 = triggerDefinition.getProperty(PROP_CUSTOM_WEEKLY_DAYOFWEEK);
            DayOfWeek dayOfWeek = string2 == null ? null : DayOfWeek.valueOf(string2);
            String string3 = triggerDefinition.getProperty(PROP_CUSTOM_MONTHLY_DAY_OF_MONTH);
            int n5 = string3 == null ? 0 : Integer.parseInt(string3);
            String string4 = triggerDefinition.getProperty(PROP_CUSTOM_MONTHLY_CARDINALITY);
            MonthlyDay monthlyDay2 = monthlyDay = string4 == null ? null : MonthlyDay.valueOf(string4);
            while (arrayList.size() < n2) {
                switch (n3) {
                    case 1: {
                        zonedDateTime4 = TimeTriggerForCustomSettings.a(zonedDateTime2, zonedDateTime3, zonedDateTime4, n4);
                        break;
                    }
                    case 2: {
                        zonedDateTime4 = TimeTriggerForCustomSettings.a(zonedDateTime2, zonedDateTime3, zonedDateTime4, n4, dayOfWeek);
                        break;
                    }
                    case 3: {
                        zonedDateTime4 = TimeTriggerForCustomSettings.a(zonedDateTime2, zonedDateTime3, zonedDateTime4, n4, monthlyDay, n5);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("type=" + n3);
                    }
                }
                if ((zonedDateTime4 = zonedDateTime4.withHour(zonedDateTime2.getHour()).withMinute(zonedDateTime2.getMinute()).withSecond(0).withNano(0)).isBefore(zonedDateTime3) || zonedDateTime4.isBefore(zonedDateTime2) || zonedDateTime != null && zonedDateTime4.isBefore(zonedDateTime)) continue;
                arrayList.add(zonedDateTime4);
            }
            return arrayList;
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            throw new IllegalArgumentException(runtimeException);
        }
    }

    private static ZonedDateTime a(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, ZonedDateTime zonedDateTime3, int n2, DayOfWeek dayOfWeek) {
        if (zonedDateTime3 != null) {
            zonedDateTime3 = zonedDateTime3.plusWeeks(n2);
        } else {
            zonedDateTime3 = TimeTriggerForCustomSettings.a(zonedDateTime, zonedDateTime2, n2, ChronoUnit.WEEKS);
            int n3 = dayOfWeek.getValue() - zonedDateTime3.getDayOfWeek().getValue();
            zonedDateTime3 = zonedDateTime3.plusDays(n3);
        }
        return zonedDateTime3;
    }

    private static ZonedDateTime a(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, ZonedDateTime zonedDateTime3, int n2) {
        zonedDateTime3 = zonedDateTime3 != null ? zonedDateTime3.plusDays(n2) : TimeTriggerForCustomSettings.a(zonedDateTime, zonedDateTime2, n2, ChronoUnit.DAYS);
        return zonedDateTime3;
    }

    private static ZonedDateTime a(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, ZonedDateTime zonedDateTime3, int n2, MonthlyDay monthlyDay, int n3) {
        block10: {
            zonedDateTime3 = zonedDateTime3 != null ? zonedDateTime3.plusMonths(n2) : TimeTriggerForCustomSettings.a(zonedDateTime, zonedDateTime2, n2, ChronoUnit.MONTHS);
            boolean bl = monthlyDay != MonthlyDay.LAST;
            int n4 = TimeTriggerForCustomSettings.getCardinalityFromSetting(zonedDateTime, monthlyDay);
            zonedDateTime3 = bl ? zonedDateTime3.withDayOfMonth(1) : zonedDateTime3.withDayOfMonth(1).plusMonths(1L).minusDays(1L);
            Month month = zonedDateTime3.getMonth();
            while (true) {
                if (TimeTriggerForCustomSettings.a(zonedDateTime3, n3)) {
                    if (--n4 == 0) break block10;
                    zonedDateTime3 = zonedDateTime3.plusDays(TimeTriggerForCustomSettings.a(zonedDateTime3, n3, bl));
                } else {
                    zonedDateTime3 = bl ? zonedDateTime3.plusDays(1L) : zonedDateTime3.minusDays(1L);
                }
                if (zonedDateTime3.getMonth() == month) continue;
                boolean bl2 = false;
                if (monthlyDay == MonthlyDay.INITIAL) {
                    if (n3 == 8) {
                        bl2 = true;
                    } else if (n3 == 9) {
                        if (zonedDateTime.getDayOfMonth() <= 23) {
                            bl2 = true;
                        }
                    } else if (zonedDateTime.getDayOfMonth() == 5) {
                        bl2 = true;
                    }
                }
                if (!bl2) break;
                n4 = TimeTriggerForCustomSettings.getCardinalityFromSetting(zonedDateTime, monthlyDay);
                month = zonedDateTime3.getMonth();
            }
            throw new IllegalArgumentException(String.format("Invalid settings for custom monthly: interval=%d, Day=%d, Cardinality=%s, startDate=%s", n2, n3, monthlyDay.toString(), zonedDateTime.format(DateTimeFormatter.ISO_DATE_TIME)));
        }
        return zonedDateTime3;
    }

    public static int getCardinalityFromSetting(ZonedDateTime startDate, MonthlyDay monthlyCardinality) {
        return switch (monthlyCardinality) {
            case MonthlyDay.FIRST -> 1;
            case MonthlyDay.FOURTH -> 4;
            case MonthlyDay.INITIAL -> startDate.getDayOfMonth();
            case MonthlyDay.LAST -> 1;
            case MonthlyDay.SECOND -> 2;
            case MonthlyDay.THIRD -> 3;
            default -> throw new IllegalArgumentException(monthlyCardinality.toString());
        };
    }

    private static long a(ZonedDateTime zonedDateTime, int n2, boolean bl) {
        DayOfWeek dayOfWeek = zonedDateTime.getDayOfWeek();
        switch (n2) {
            case 8: {
                return bl ? 1L : -1L;
            }
            case 9: {
                if (dayOfWeek == DayOfWeek.FRIDAY) {
                    return bl ? 3L : -1L;
                }
                if (dayOfWeek == DayOfWeek.MONDAY) {
                    return bl ? 1L : -3L;
                }
                return bl ? 1L : -1L;
            }
        }
        return bl ? 7L : -7L;
    }

    private static boolean a(ZonedDateTime zonedDateTime, int n2) {
        int n3 = zonedDateTime.getDayOfWeek().getValue();
        switch (n2) {
            case 8: {
                return true;
            }
            case 9: {
                return n3 >= DayOfWeek.MONDAY.getValue() && n3 <= DayOfWeek.FRIDAY.getValue();
            }
        }
        return n3 == n2;
    }

    private static ZonedDateTime a(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, int n2, ChronoUnit chronoUnit) {
        long l2 = TimeTriggerForCustomSettings.a(zonedDateTime, zonedDateTime2, chronoUnit);
        if (l2 <= 0L) {
            return zonedDateTime;
        }
        long l3 = l2 % (long)n2;
        long l4 = l3 == 0L ? 0L : (long)n2 - l3;
        return zonedDateTime2.plus(l4, chronoUnit);
    }

    private static long a(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, ChronoUnit chronoUnit) {
        long l2 = chronoUnit.between(zonedDateTime.toLocalDate(), zonedDateTime2.toLocalDate());
        if (chronoUnit == ChronoUnit.DAYS) {
            return l2;
        }
        if (chronoUnit == ChronoUnit.WEEKS) {
            if (zonedDateTime2.isAfter(zonedDateTime) && zonedDateTime.getDayOfWeek().getValue() > zonedDateTime2.getDayOfWeek().getValue()) {
                ++l2;
            } else if (zonedDateTime2.isBefore(zonedDateTime) && zonedDateTime.getDayOfWeek().getValue() < zonedDateTime2.getDayOfWeek().getValue()) {
                --l2;
            }
        } else if (chronoUnit == ChronoUnit.MONTHS) {
            if (zonedDateTime2.isAfter(zonedDateTime) && zonedDateTime.getDayOfMonth() > zonedDateTime2.getDayOfMonth()) {
                ++l2;
            } else if (zonedDateTime2.isBefore(zonedDateTime) && zonedDateTime.getDayOfMonth() < zonedDateTime2.getDayOfMonth()) {
                --l2;
            }
        }
        return l2;
    }

    public static List<ZonedDateTime> getNextExecutionDates(TriggerDefinition definition) {
        return TimeTriggerForCustomSettings.a(definition, null, 3);
    }

    public static String generateNiceReadableSentenceForExecution(ZonedDateTime startDate, String localizedStartTime, TriggerDefinition definition) {
        try {
            int n2 = Integer.parseInt(definition.getProperty(PROP_CUSTOM_INTERVALTYPE));
            String string = definition.getProperty(PROP_CUSTOM_INTERVAL);
            int n3 = string == null ? 0 : Math.max(Integer.parseInt(string), 1);
            String string2 = definition.getProperty(PROP_CUSTOM_WEEKLY_DAYOFWEEK);
            DayOfWeek dayOfWeek = string2 == null ? null : DayOfWeek.valueOf(string2);
            String string3 = definition.getProperty(PROP_CUSTOM_MONTHLY_DAY_OF_MONTH);
            int n4 = string3 == null ? 0 : Integer.parseInt(string3);
            String string4 = definition.getProperty(PROP_CUSTOM_MONTHLY_CARDINALITY);
            MonthlyDay monthlyDay = string4 == null ? null : MonthlyDay.valueOf(string4);
            switch (n2) {
                case 1: {
                    if (n3 == 1) {
                        return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.daily", new Object[]{localizedStartTime});
                    }
                    return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.custom.daily", new Object[]{n3, localizedStartTime});
                }
                case 2: {
                    String string5 = TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + dayOfWeek.name(), new Object[0]);
                    return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.custom.weekly", new Object[]{n3, string5, localizedStartTime});
                }
                case 3: {
                    int n5 = TimeTriggerForCustomSettings.getCardinalityFromSetting(startDate, monthlyDay);
                    if (monthlyDay == MonthlyDay.LAST) {
                        n5 = 0;
                    }
                    return TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.custom.monthly", new Object[]{n3, n5, switch (n4) {
                        case 8 -> TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.monthlyday.day", new Object[0]);
                        case 9 -> TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.monthlyday.weekDay", new Object[0]);
                        default -> TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.of(n4).name(), new Object[0]);
                    }, localizedStartTime});
                }
            }
            throw new IllegalArgumentException("Unknown type: " + n2);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)runtimeException);
            throw new IllegalArgumentException(runtimeException);
        }
    }
}

