/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.job;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.AbstractFactory;
import com.inet.taskplanner.server.api.common.SeriesDependentFactory;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class JobFactory<T extends Job>
extends SeriesDependentFactory<T, JobDefinition, JobInfo, JobSummaryInfo> {
    public JobFactory(String extensionName) {
        super(extensionName);
    }

    public abstract List<ResultFlavor> getResultFlavors(JobDefinition var1);

    public final void validateCondition(@Nonnull JobDefinition definition, @Nullable SeriesDefinition seriesDefinition, @Nullable GUID taskID) throws ValidationException {
        if (seriesDefinition != null) {
            try {
                Map<String, String> map = null;
                try {
                    map = this.getFirstValueFromSeries(seriesDefinition, taskID);
                }
                catch (Throwable throwable) {
                    TaskPlannerServerPlugin.LOGGER.debug((Object)throwable);
                }
                if (map != null) {
                    JobDefinition jobDefinition = this.patchDefinitionProperties(definition, map, taskID);
                    this.validateCondition(jobDefinition);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new ValidationException(new String[]{illegalStateException.getMessage()});
            }
        }
        this.validateCondition(definition);
    }

    @Override
    protected final JobDefinition patchDefinitionProperties(JobDefinition baseDefinition, Map<String, String> seriesProperties, @Nullable GUID taskID) {
        JobInfo jobInfo;
        if (!this.isAutoResolvePlaceholders()) {
            return this.customPatchDefinitionProperties(baseDefinition, seriesProperties, taskID);
        }
        JobDefinition jobDefinition = super.patchDefinitionProperties(baseDefinition, seriesProperties, taskID);
        ConditionDefinition conditionDefinition = jobDefinition.getCondition();
        if (seriesProperties != null && conditionDefinition != null && (jobInfo = (JobInfo)this.getInformation(taskID)) != null && jobInfo.getConditionInfo() != null) {
            Map<String, String> map = conditionDefinition.getProperties();
            jobInfo.getConditionInfo().getFields().stream().forEach(field -> map.put(field.getKey(), field.patchSeriesPlaceholderInValue((String)map.get(field.getKey()), seriesProperties)));
        }
        return jobDefinition;
    }

    protected abstract void validateCondition(@Nonnull JobDefinition var1) throws ValidationException;

    public boolean isAutoResolvePlaceholders() {
        return true;
    }

    protected JobDefinition customPatchDefinitionProperties(JobDefinition baseDefinition, Map<String, String> seriesProperties, @Nullable GUID taskID) {
        return baseDefinition;
    }

    public boolean hasPlaceholderSet(String value, GUID taskID) {
        Object object;
        Object object22;
        Iterator iterator;
        Object object3;
        Object object4;
        if (value == null || value.trim().isEmpty() || taskID == null) {
            return false;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        TaskDefinition taskDefinition = TaskPlanner.getInstance().getTaskDefinition(taskID);
        if (taskDefinition != null) {
            object4 = taskDefinition.getTriggers();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                iterator = (TriggerDefinition)object3.next();
                try {
                    object22 = (TriggerFactory)ServerPluginManager.getInstance().getSingleInstanceByName(TriggerFactory.class, ((AbstractDefinition)((Object)iterator)).getExtensionName(), false);
                    object = (TriggerInfo)((AbstractFactory)object22).getInformation(taskID);
                    List<String> list = ((TriggerInfo)object).getPlaceholderKeys();
                    if (list == null) continue;
                    for (String string : list) {
                        String string2 = "{" + string + "}";
                        if (hashSet.contains(string2)) continue;
                        hashSet.add(string2);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
        }
        if ((object3 = ((JobInfo)(object4 = (JobInfo)this.getInformation(taskID))).getPlaceholderKeys()) != null) {
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object22 = (String)iterator.next();
                object = "[" + (String)object22 + "]";
                if (hashSet.contains(object)) continue;
                hashSet.add(object);
            }
        }
        for (Object object22 : hashSet) {
            if (!value.contains((CharSequence)object22)) continue;
            return true;
        }
        return false;
    }
}

