/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action.savefile;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.action.savefile.a;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.FilenameField;
import com.inet.taskplanner.server.api.field.FolderField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class SaveFileResultActionFactory
extends ResultActionFactory<a> {
    public static final String EXTENSION_NAME = "result.savefile";
    public static final String PROPERTY_DESTINATION = "destination";
    public static final String PROPERTY_FILENAME_FORMAT = "filenameformat";
    public static final String PROPERTY_DELETE_DAYS = "deletedays";

    public SaveFileResultActionFactory() {
        super(EXTENSION_NAME);
    }

    @Override
    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.FILE);
    }

    @Override
    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("result.savefile.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("result.savefile.description", new Object[0]);
        URL uRL = this.getClass().getResource("/com/inet/taskplanner/server/api/action/savefile/savefile.png");
        String string3 = "taskplanner.action.savefile";
        FolderField folderField = new FolderField(PROPERTY_DESTINATION, TaskPlannerServerPlugin.MSG.getMsg("result.savefile.destination", new Object[0]));
        folderField.setProtocols(FileServiceForTaskPlanner.getAllAvailableProtocols());
        FilenameField filenameField = new FilenameField(PROPERTY_FILENAME_FORMAT, TaskPlannerServerPlugin.MSG.getMsg("result.savefile.filenameformat", new Object[0]));
        filenameField.setValue("[filename] [date] [time]");
        NumberField numberField = new NumberField(PROPERTY_DELETE_DAYS, TaskPlannerServerPlugin.MSG.getMsg("result.savefile.deletedays", new Object[0]));
        List<String> list = Arrays.asList("filename", "date", "time");
        return new ResultActionInfo(this.getExtensionName(), string, string2, uRL, string3, Arrays.asList(folderField, filenameField, numberField), list);
    }

    @Override
    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        Object object;
        String string = definition.getProperty(PROPERTY_DESTINATION);
        if (string == null || string.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("result.savefile.error.nodir", new Object[0])});
        }
        if (!this.hasPlaceholderSet(string, taskID) && (object = FileServiceForTaskPlanner.getServiceFor(string)) != null) {
            object.validateDirPath(string);
        }
        if ((object = definition.getProperty(PROPERTY_FILENAME_FORMAT)) == null || ((String)object).trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("result.savefile.error.nofilenameformat", new Object[0])});
        }
        String string2 = definition.getProperty(PROPERTY_DELETE_DAYS);
        if (!StringFunctions.isEmpty((String)string2)) {
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < 0) {
                    throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("result.savefile.error.invaliddaynumber", new Object[0])});
                }
            }
            catch (Exception exception) {
                throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("result.savefile.error.invaliddaynumber", new Object[0])});
            }
        }
    }

    protected a c(@Nonnull ResultActionDefinition resultActionDefinition, @Nullable GUID gUID) {
        return new a(resultActionDefinition.getProperty(PROPERTY_DESTINATION), resultActionDefinition.getProperty(PROPERTY_FILENAME_FORMAT), resultActionDefinition.getProperty(PROPERTY_DELETE_DAYS));
    }

    @Override
    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("result.savefile.summary.path", new Object[0]), definition.getProperty(PROPERTY_DESTINATION)));
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("result.savefile.summary.filenameformat", new Object[0]), definition.getProperty(PROPERTY_FILENAME_FORMAT)));
        return new SummaryInfo(arrayList);
    }

    @Override
    public boolean isAvailable() {
        List list = ServerPluginManager.getInstance().get(FileServiceForTaskPlanner.class);
        for (FileServiceForTaskPlanner fileServiceForTaskPlanner : list) {
            Permission permission = fileServiceForTaskPlanner.getRequiredPermission();
            if (permission != null && !SystemPermissionChecker.checkAccess((Permission)permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected /* synthetic */ Object createInstanceFrom(@Nonnull AbstractDefinition abstractDefinition, @Nullable GUID gUID) {
        return this.c((ResultActionDefinition)abstractDefinition, gUID);
    }
}

