/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import java.io.File;
import java.nio.file.Path;
import javax.annotation.Nonnull;

@PublicApi
public class FileSystemResultActionBuilder {
    private String t;
    private String u = "[filename] [date] [time]";

    public FileSystemResultActionBuilder(@Nonnull Path destinationFolder) {
        this.withDestinationFolder(destinationFolder);
    }

    public FileSystemResultActionBuilder(@Nonnull File destinationFolder) {
        this.withDestinationFolder(destinationFolder);
    }

    public FileSystemResultActionBuilder(@Nonnull String destinationFolder) {
        this.withDestinationFolder(destinationFolder);
    }

    public FileSystemResultActionBuilder withDestinationFolder(@Nonnull Path destinationFolder) {
        if (destinationFolder == null) {
            throw new IllegalArgumentException("destinationFolder cannot be null");
        }
        this.t = destinationFolder.toString();
        return this;
    }

    public FileSystemResultActionBuilder withDestinationFolder(@Nonnull File destinationFolder) {
        if (destinationFolder == null) {
            throw new IllegalArgumentException("destinationFolder cannot be null");
        }
        return this.withDestinationFolder(destinationFolder.toPath());
    }

    public FileSystemResultActionBuilder withDestinationFolder(@Nonnull String destinationFolder) {
        if (destinationFolder == null) {
            throw new IllegalArgumentException("destinationFolder cannot be null");
        }
        this.t = destinationFolder;
        return this;
    }

    public FileSystemResultActionBuilder withFileNameFormat(String fileNameFormat) {
        if (fileNameFormat == null || fileNameFormat.isEmpty()) {
            throw new IllegalArgumentException("fileNameFormat cannot be null or empty");
        }
        this.u = fileNameFormat;
        return this;
    }

    public ResultActionDefinition create() {
        ResultActionDefinition resultActionDefinition = new ResultActionDefinition("result.savefile");
        resultActionDefinition.setProperty("destination", this.t);
        resultActionDefinition.setProperty("filenameformat", this.u);
        return resultActionDefinition;
    }
}

