/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.filechange;

import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.field.FolderField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeObserver;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeService;
import com.inet.taskplanner.server.api.trigger.filechange.a;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class FileChangeTriggerFactory
extends TriggerFactory<a> {
    public static final String EXTENSION_NAME = "trigger.filechange";
    public static final String PROPERTY_TYPE = "type";
    public static final String VALUE_FILE = "file";
    public static final String VALUE_FOLDER = "folder";
    public static final String PROPERTY_FILE_PATH = "filepath";
    public static final String PROPERTY_FOLDER_PATH = "folderpath";

    public FileChangeTriggerFactory() {
        super(EXTENSION_NAME);
    }

    @Override
    protected a createInstanceFrom(TriggerDefinition definition, GUID taskID) {
        String string = FileChangeTriggerFactory.getPathOutOfDef(definition);
        FileChangeService fileChangeService = FileChangeService.getServiceFor(string);
        if (fileChangeService == null) {
            throw new IllegalStateException(TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.error.invalidPath", new Object[]{string}));
        }
        boolean bl = VALUE_FOLDER.equals(definition.getProperty(PROPERTY_TYPE));
        try {
            FileChangeObserver fileChangeObserver = fileChangeService.createObserver(string, bl);
            return new a(fileChangeObserver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object object = "<null>";
            if (taskID != null) {
                TaskDefinition taskDefinition = TaskPlanner.getInstance().getTaskDefinition(taskID);
                object = taskDefinition != null ? taskDefinition.getName() : String.valueOf(taskID);
            }
            throw new IllegalArgumentException("For task " + (String)object + ": " + illegalArgumentException.toString(), illegalArgumentException);
        }
    }

    @Override
    public TriggerInfo getInformation(GUID taskID) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.description", new Object[0]);
        URL uRL = this.getClass().getResource("/com/inet/taskplanner/server/api/trigger/filechange/filechange.png");
        String string3 = "taskplanner.trigger.filechange";
        ArrayList<Field> arrayList = new ArrayList<Field>();
        ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
        arrayList2.add(new LocalizedKey(VALUE_FILE, TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.type.file", new Object[0])));
        arrayList2.add(new LocalizedKey(VALUE_FOLDER, TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.type.folder", new Object[0])));
        SelectField selectField = new SelectField(PROPERTY_TYPE, TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.type.label", new Object[0]), arrayList2);
        selectField.setValue(VALUE_FILE);
        arrayList.add(selectField);
        FileField fileField = new FileField(PROPERTY_FILE_PATH, TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.type.file.label", new Object[0]));
        ArrayList<FieldCondition> arrayList3 = new ArrayList<FieldCondition>();
        arrayList3.add(FieldCondition.visible(selectField, FieldCondition.OP.equals, VALUE_FILE));
        fileField.setConditions(arrayList3);
        fileField.setProtocols(FileChangeService.getAllAvailableProtocols());
        arrayList.add(fileField);
        FolderField folderField = new FolderField(PROPERTY_FOLDER_PATH, TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.type.folder.label", new Object[0]));
        ArrayList<FieldCondition> arrayList4 = new ArrayList<FieldCondition>();
        arrayList4.add(FieldCondition.visible(selectField, FieldCondition.OP.equals, VALUE_FOLDER));
        folderField.setConditions(arrayList4);
        folderField.setProtocols(FileChangeService.getAllAvailableProtocols());
        arrayList.add(folderField);
        TriggerInfo triggerInfo = new TriggerInfo(this.getExtensionName(), string, string2, uRL, string3, arrayList);
        return triggerInfo;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Files are not read, just referenced and prepared for triggering a change event.")
    public void validate(TriggerDefinition triggerDefinition, GUID taskID) throws ValidationException {
        String string = FileChangeTriggerFactory.getPathOutOfDef(triggerDefinition);
        if (string == null) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.error.noPath", new Object[0])});
        }
        FileChangeService fileChangeService = FileChangeService.getServiceFor(string);
        if (fileChangeService != null) {
            fileChangeService.validatePath(string);
        }
    }

    @Nullable
    public static String getPathOutOfDef(TriggerDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("definition must not be null");
        }
        String string = definition.getProperty(PROPERTY_TYPE);
        String string2 = null;
        if (string == null || string.isEmpty()) {
            string = VALUE_FILE;
        }
        string2 = VALUE_FILE.equals(string) ? definition.getProperty(PROPERTY_FILE_PATH) : definition.getProperty(PROPERTY_FOLDER_PATH);
        return string2;
    }

    @Override
    public SummaryInfo getSummary(TriggerDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string = definition.getProperty(PROPERTY_TYPE);
        String string2 = null;
        if (string == null || string.isEmpty()) {
            string = VALUE_FILE;
        }
        string2 = VALUE_FILE.equals(string) ? definition.getProperty(PROPERTY_FILE_PATH) : definition.getProperty(PROPERTY_FOLDER_PATH);
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("trigger.filechange.summary." + string, new Object[0]), string2));
        return new SummaryInfo(arrayList);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean isAvailable() {
        @Nonnull List list = ServerPluginManager.getInstance().get(FileChangeService.class);
        for (FileChangeService fileChangeService : list) {
            Permission permission = fileChangeService.getRequiredPermission();
            if (permission != null && !SystemPermissionChecker.checkAccess((Permission)permission)) continue;
            return true;
        }
        return false;
    }
}

