/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.series;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class DbSeriesBuilder {
    private String aE;
    private String aF;
    private String aG;
    private String aH;

    public DbSeriesBuilder withUrl(@Nonnull String url) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("Url cannot be null or empty!");
        }
        this.aF = url;
        return this;
    }

    public DbSeriesBuilder withSql(@Nonnull String sql) {
        if (sql == null || sql.isEmpty()) {
            throw new IllegalArgumentException("Sql cannot be null or empty!");
        }
        this.aH = sql;
        return this;
    }

    public DbSeriesBuilder withPassword(@Nullable String password) {
        this.aG = password;
        return this;
    }

    public DbSeriesBuilder withUsername(@Nullable String user) {
        this.aE = user;
        return this;
    }

    public SeriesDefinition create() {
        SeriesDefinition seriesDefinition = new SeriesDefinition("series.db");
        seriesDefinition.setProperty("url", this.aF);
        seriesDefinition.setProperty("username", this.aE);
        seriesDefinition.setProperty("password", this.aG);
        seriesDefinition.setProperty("sql", this.aH);
        return seriesDefinition;
    }
}

