/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.SliderConfigProperty;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldType;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class RangeField
extends Field {
    private SliderConfigProperty.SliderBound lowerBound;
    private SliderConfigProperty.SliderBound upperBound;
    private boolean showValue;

    public RangeField(String key, String label, SliderConfigProperty.SliderBound lowerBound, SliderConfigProperty.SliderBound upperBound, boolean showValue) {
        super(FieldType.NUMBER_RANGE, key, label);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.showValue = showValue;
    }

    @Nullable
    public static NumberRange fromRangeFieldValue(String value) {
        try {
            return (NumberRange)new Json().fromJson(value, NumberRange.class);
        }
        catch (JsonException | NullPointerException throwable) {
            return null;
        }
    }

    @JsonData
    public class NumberRange {
        private Number firstValue;
        private Number secondValue;

        private NumberRange() {
        }

        public Number getFirstValue() {
            return this.firstValue;
        }

        public Number getSecondValue() {
            return this.secondValue;
        }
    }
}

