/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.lowmemory;

import com.inet.annotations.PublicApi;
import com.inet.cache.internal.MemoryObserver;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.taskplanner.server.api.trigger.lowmemory.a;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class LowMemoryTriggerFactory
extends TriggerFactory<a> {
    public static final String EXTENSION_NAME = "trigger.lowmemory";

    public LowMemoryTriggerFactory() {
        super(EXTENSION_NAME);
    }

    @Override
    protected a createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        long l2;
        double d2;
        try {
            d2 = Double.parseDouble(definition.getProperty("trigger.lowmemory.threshold")) / 100.0;
        }
        catch (NumberFormatException numberFormatException) {
            d2 = MemoryObserver.LOW_MEMEORY_THRESHOLD;
        }
        try {
            l2 = Long.parseLong(definition.getProperty("trigger.lowmemory.interval"));
        }
        catch (NumberFormatException numberFormatException) {
            l2 = 1800L;
        }
        return new a(d2, l2);
    }

    @Override
    public TriggerInfo getInformation(@Nullable GUID taskID) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.description", new Object[0]);
        URL uRL = this.getClass().getResource("lowmemory_32.png");
        String string3 = "taskplanner.trigger.lowmemory";
        ArrayList<Field> arrayList = new ArrayList<Field>();
        NumberField numberField = new NumberField("trigger.lowmemory.threshold", TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.threshold", new Object[0]), Collections.singletonList(new UnitConfigProperty.Unit(1.0, "%")));
        numberField.setValue(String.valueOf((int)Math.ceil(MemoryObserver.LOW_MEMEORY_THRESHOLD * 100.0)));
        arrayList.add(numberField);
        ArrayList<UnitConfigProperty.Unit> arrayList2 = new ArrayList<UnitConfigProperty.Unit>();
        arrayList2.add(new UnitConfigProperty.Unit(2.777777777777778E-4, TaskPlannerServerPlugin.MSG.getMsg("hours", new Object[0])));
        arrayList2.add(new UnitConfigProperty.Unit(0.016666666666666666, TaskPlannerServerPlugin.MSG.getMsg("minutes", new Object[0])));
        numberField = new NumberField("trigger.lowmemory.interval", TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.interval", new Object[0]), arrayList2);
        numberField.setValue("1800");
        arrayList.add(numberField);
        List<String> list = Collections.singletonList("memsize");
        TriggerInfo triggerInfo = new TriggerInfo(EXTENSION_NAME, string, string2, uRL, string3, arrayList, list);
        return triggerInfo;
    }

    @Override
    public void validate(@Nonnull TriggerDefinition definition, GUID taskID) throws ValidationException {
        try {
            double d2 = Double.parseDouble(definition.getProperty("trigger.lowmemory.threshold"));
            int n2 = (int)Math.ceil(MemoryObserver.LOW_MEMEORY_THRESHOLD * 100.0);
            if (d2 < (double)n2 || d2 > 99.0) {
                throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.error.threshold", new Object[]{n2})});
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(new String[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)numberFormatException)});
        }
        try {
            long l2 = Long.parseLong(definition.getProperty("trigger.lowmemory.interval"));
            if (l2 <= 0L) {
                throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.error.interval", new Object[0])});
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException(new String[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)numberFormatException)});
        }
    }

    @Override
    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("trigger.lowmemory.summary", new Object[0]), definition.getProperty("trigger.lowmemory.threshold") + "%"));
        return new SummaryInfo(arrayList);
    }

    @Override
    public boolean isAvailable() {
        return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
    }
}

