/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.AbstractFactory;
import com.inet.taskplanner.server.api.common.SeriesDependentFactory;
import com.inet.taskplanner.server.api.common.SeriesIndependentFactory;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public class TaskDefinition {
    private boolean activated = true;
    private String name = "";
    private String description = "";
    private List<TriggerDefinition> triggers = new ArrayList<TriggerDefinition>();
    private List<JobDefinition> jobs = new ArrayList<JobDefinition>();
    private List<ResultActionDefinition> actions = new ArrayList<ResultActionDefinition>();
    private SeriesDefinition series;
    private boolean systemTask = false;

    private TaskDefinition() {
    }

    public TaskDefinition(@Nonnull String name) {
        this.setName(name);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        this.description = description;
    }

    public boolean isSystemTask() {
        return this.systemTask;
    }

    public void setSystemTask(boolean systemTask) {
        if (this.systemTask == systemTask) {
            return;
        }
        this.systemTask = systemTask;
    }

    @Nullable
    public SeriesDefinition getSeries() {
        return this.series;
    }

    public void setSeries(@Nullable SeriesDefinition series) {
        this.series = series;
    }

    @Nonnull
    public List<TriggerDefinition> getTriggers() {
        return Collections.unmodifiableList(this.triggers);
    }

    @Nonnull
    public TaskDefinition addTrigger(@Nullable TriggerDefinition definition) {
        if (definition != null && !this.triggers.contains(definition)) {
            this.triggers.add(definition);
        }
        return this;
    }

    public boolean removeTrigger(@Nullable TriggerDefinition definition) {
        return this.triggers.remove(definition);
    }

    @Nonnull
    public List<JobDefinition> getJobs() {
        return Collections.unmodifiableList(this.jobs);
    }

    @Nonnull
    public TaskDefinition addJob(@Nullable JobDefinition definition) {
        if (definition != null && !this.jobs.contains(definition)) {
            this.jobs.add(definition);
        }
        return this;
    }

    public boolean removeJob(@Nullable JobDefinition definition) {
        return this.jobs.remove(definition);
    }

    @Nonnull
    public List<ResultActionDefinition> getResultActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Nonnull
    public TaskDefinition addResultAction(@Nullable ResultActionDefinition definition) {
        if (definition != null && !this.actions.contains(definition)) {
            this.actions.add(definition);
        }
        return this;
    }

    public boolean removeResultAction(@Nullable ResultActionDefinition definition) {
        return this.actions.remove(definition);
    }

    public TaskDefinition copyTaskModel() {
        TaskDefinition taskDefinition = new TaskDefinition();
        taskDefinition.setName(this.name);
        taskDefinition.setDescription(this.description);
        taskDefinition.setActivated(this.isActivated());
        taskDefinition.triggers = AbstractDefinition.copyDefinitions(this.triggers);
        taskDefinition.jobs = AbstractDefinition.copyDefinitions(this.jobs);
        taskDefinition.actions = AbstractDefinition.copyDefinitions(this.actions);
        if (this.series != null) {
            taskDefinition.series = this.series.copyDefinition();
        }
        taskDefinition.systemTask = this.systemTask;
        return taskDefinition;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.activated ? 1231 : 1237);
        n3 = 31 * n3 + (this.systemTask ? 1231 : 1237);
        n3 = 31 * n3 + Objects.hashCode(this.name);
        n3 = 31 * n3 + Objects.hashCode(this.description);
        n3 = 31 * n3 + Objects.hashCode(this.triggers);
        n3 = 31 * n3 + Objects.hashCode(this.series);
        n3 = 31 * n3 + Objects.hashCode(this.jobs);
        n3 = 31 * n3 + Objects.hashCode(this.actions);
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskDefinition taskDefinition = (TaskDefinition)obj;
        if (this.activated != taskDefinition.activated) {
            return false;
        }
        if (this.systemTask != taskDefinition.systemTask) {
            return false;
        }
        if (this.description == null ? taskDefinition.description != null : !this.description.equals(taskDefinition.description)) {
            return false;
        }
        if (this.jobs == null ? taskDefinition.jobs != null : !this.jobs.equals(taskDefinition.jobs)) {
            return false;
        }
        if (this.name == null ? taskDefinition.name != null : !this.name.equals(taskDefinition.name)) {
            return false;
        }
        if (this.actions == null ? taskDefinition.actions != null : !this.actions.equals(taskDefinition.actions)) {
            return false;
        }
        if (this.triggers == null ? taskDefinition.triggers != null : !this.triggers.equals(taskDefinition.triggers)) {
            return false;
        }
        return Objects.equals(this.series, taskDefinition.series);
    }

    public void validate() throws ValidationException {
        this.validate(null);
    }

    public void validate(GUID taskID) throws ValidationException {
        AbstractFactory illegalStateException;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TriggerDefinition abstractDefinition : this.triggers) {
            try {
                illegalStateException = (TriggerFactory)ServerPluginManager.getInstance().getSingleInstanceByName(TriggerFactory.class, abstractDefinition.getExtensionName(), false);
                ((SeriesIndependentFactory)illegalStateException).validate(abstractDefinition, taskID);
            }
            catch (IllegalStateException validationException) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.validation.extensionMissing", new Object[]{abstractDefinition.getExtensionName()}));
            }
            catch (ValidationException validationException) {
                arrayList.addAll(validationException.getErrors());
            }
        }
        for (JobDefinition jobDefinition : this.jobs) {
            try {
                illegalStateException = (JobFactory)ServerPluginManager.getInstance().getSingleInstanceByName(JobFactory.class, jobDefinition.getExtensionName(), false);
                try {
                    ((SeriesDependentFactory)illegalStateException).validate(jobDefinition, this.series, taskID);
                }
                catch (ValidationException validationException) {
                    arrayList.addAll(validationException.getErrors());
                }
                if (jobDefinition.getCondition() == null) continue;
                try {
                    ((JobFactory)illegalStateException).validateCondition(jobDefinition, this.series, taskID);
                }
                catch (ValidationException validationException) {
                    arrayList.addAll(validationException.getErrors());
                }
            }
            catch (IllegalStateException illegalStateException2) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("job.validation.extensionMissing", new Object[]{jobDefinition.getExtensionName()}));
            }
        }
        for (ResultActionDefinition resultActionDefinition : this.actions) {
            try {
                illegalStateException = (ResultActionFactory)ServerPluginManager.getInstance().getSingleInstanceByName(ResultActionFactory.class, resultActionDefinition.getExtensionName(), false);
                ((SeriesDependentFactory)illegalStateException).validate(resultActionDefinition, this.series, taskID);
            }
            catch (IllegalStateException illegalStateException3) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("handler.validation.extensionMissing", new Object[]{resultActionDefinition.getExtensionName()}));
            }
            catch (ValidationException validationException) {
                arrayList.addAll(validationException.getErrors());
            }
        }
        if (this.series != null) {
            try {
                SeriesFactory seriesFactory = (SeriesFactory)ServerPluginManager.getInstance().getSingleInstanceByName(SeriesFactory.class, this.series.getExtensionName(), false);
                seriesFactory.validate(this.series, taskID);
            }
            catch (IllegalStateException illegalStateException4) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("series.validation.extensionMissing", new Object[]{this.series.getExtensionName()}));
            }
            catch (ValidationException validationException) {
                arrayList.addAll(validationException.getErrors());
            }
        }
        if (!arrayList.isEmpty()) {
            throw new ValidationException(arrayList);
        }
    }
}

