/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid.viewtask;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(description="Container for information about a single trigger.")
@JsonData
public class TriggerDescription {
    @Schema(description="Unique identifier of the trigger.", example="trigger123")
    private String id;
    @Schema(description="Properties of the trigger.")
    private Map<String, String> properties;

    private TriggerDescription() {
    }

    public static TriggerDescription from(TriggerDefinition definition) {
        TriggerDescription triggerDescription = new TriggerDescription();
        triggerDescription.id = definition.getExtensionName();
        triggerDescription.properties = definition.getProperties();
        return triggerDescription;
    }

    public static TriggerDefinition toTrigger(TriggerDescription description, GUID taskId) {
        TriggerFactory triggerFactory = (TriggerFactory)ServerPluginManager.getInstance().getSingleInstanceByName(TriggerFactory.class, description.id, false);
        TriggerInfo triggerInfo = (TriggerInfo)triggerFactory.getInformation(taskId);
        for (Field field : triggerInfo.getFields()) {
            if (description.properties.containsKey(field.getKey())) continue;
            description.properties.put(field.getKey(), field.getValue());
        }
        TriggerDefinition triggerDefinition = new TriggerDefinition(description.id, description.properties);
        try {
            triggerFactory.validate(triggerDefinition, taskId);
        }
        catch (ValidationException validationException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)validationException);
            throw new ClientMessageException(validationException.getMessage());
        }
        return triggerDefinition;
    }
}

