/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.fileservice;

import com.inet.classloader.BaseLocator;
import com.inet.http.ClientMessageException;
import com.inet.lib.io.FastBufferedOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.permissions.Permission;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionHelper;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class a
implements FileServiceForTaskPlanner {
    @Nonnull
    public String getExtensionName() {
        return "file";
    }

    @Override
    @Nullable
    public Permission getRequiredPermission() {
        return Permission.CONFIGURATION;
    }

    @Override
    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This method is called by component, which can only be run by admin users.")
    public InputStream readFile(@Nonnull String path) throws IOException {
        Path path2 = this.c(path).toPath();
        if (!Files.exists(path2, new LinkOption[0])) {
            return null;
        }
        return Files.newInputStream(path2, new OpenOption[0]);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Validation of path. This method is called by component, which can only be run by admin users.")
    public void validateFilePath(@Nonnull String file) throws ValidationException {
        boolean bl = true;
        try {
            Path path = this.c(file).toPath();
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                bl = false;
            }
            if (BaseLocator.isRestrictedPath((Path)path)) {
                bl = false;
            }
        }
        catch (MalformedURLException | InvalidPathException exception) {
            bl = false;
        }
        if (!bl) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("filesystemservice.error.isnofile", new Object[0])});
        }
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Validation of path. This method is called by component, which can only be run by admin users.")
    public void validateDirPath(@Nonnull String directory) throws ValidationException {
        boolean bl = true;
        try {
            Path path = this.c(directory).toPath();
            if (!Files.isDirectory(path, new LinkOption[0])) {
                bl = false;
            }
            if (BaseLocator.isRestrictedPath((Path)path)) {
                bl = false;
            }
        }
        catch (MalformedURLException | InvalidPathException exception) {
            bl = false;
        }
        if (!bl) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("filesystemservice.error.isnodir", new Object[0])});
        }
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This method is called by action, which can only be run by admin users.")
    public void saveFile(@Nonnull String fileName, @Nonnull String fileNameFormat, @Nonnull String destination, @Nonnull InputStream inputStream, @Nullable Map<String, String> extraMetaData) throws IOException {
        Object object;
        ResultActionHelper resultActionHelper = new ResultActionHelper();
        String string = resultActionHelper.resolveFilenamePlaceholder(fileName, fileNameFormat, extraMetaData);
        String string2 = resultActionHelper.resolvePlaceholder(fileName, destination);
        object = (String)object + (((String)(object = string2)).endsWith("/") || ((String)object).endsWith("\\") ? "" : "/");
        File file = this.c((String)(object = (String)object + string));
        if (BaseLocator.isRestrictedPath((Path)file.toPath())) {
            throw new ClientMessageException(TaskPlannerServerPlugin.MSG.getMsg("filesystemservice.error.restricted", new Object[0]));
        }
        file.getParentFile().mkdirs();
        try (FastBufferedOutputStream fastBufferedOutputStream = new FastBufferedOutputStream((OutputStream)new FileOutputStream(file));){
            IOFunctions.copyData((InputStream)inputStream, (OutputStream)fastBufferedOutputStream);
        }
    }

    private File c(@Nonnull String string) throws MalformedURLException {
        URL uRL = IOFunctions.getFileURL((String)string);
        return IOFunctions.getFile((URL)uRL);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This method is called by action, which can only be run by admin users.")
    public void deleteOldFiles(@Nonnull String fileName, @Nonnull String fileNameFormat, @Nonnull String destination, long deleteOldTime) throws IOException {
        if (deleteOldTime == 0L) {
            return;
        }
        if (fileName.contains("/") || fileName.contains("\\")) {
            return;
        }
        ResultActionHelper resultActionHelper = new ResultActionHelper(){

            @Override
            public String getCurrentDate() {
                return "*";
            }

            @Override
            public String getCurrentTime() {
                return "*";
            }
        };
        String string = resultActionHelper.resolvePlaceholder(fileName, destination).replace("**", "*");
        if (string.contains("*")) {
            return;
        }
        final String string2 = "\\E.*?\\Q";
        resultActionHelper = new ResultActionHelper(){

            @Override
            public String getCurrentDate() {
                return string2;
            }

            @Override
            public String getCurrentTime() {
                return string2;
            }
        };
        Path path2 = this.c(string).toPath();
        if (BaseLocator.isRestrictedPath((Path)path2)) {
            throw new ClientMessageException(TaskPlannerServerPlugin.MSG.getMsg("filesystemservice.error.restricted", new Object[0]));
        }
        String string3 = "^\\Q" + resultActionHelper.resolveFilenamePlaceholder(fileName, fileNameFormat, null) + "\\E$";
        DirectoryStream.Filter<Path> filter = path -> path.getFileName().toString().matches(string3);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, filter);){
            for (Path path3 : directoryStream) {
                if (Files.getLastModifiedTime(path3, new LinkOption[0]).toMillis() >= deleteOldTime) continue;
                Files.delete(path3);
            }
        }
    }
}

