/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.fileservice;

import com.inet.annotations.InternalApi;
import com.inet.permissions.Permission;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.error.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface FileServiceForTaskPlanner
extends NamedExtension {
    @Nullable
    public Permission getRequiredPermission();

    @Nullable
    public InputStream readFile(@Nonnull String var1) throws IOException;

    public void saveFile(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull InputStream var4, @Nullable Map<String, String> var5) throws IOException;

    public void deleteOldFiles(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, long var4) throws IOException;

    public void validateFilePath(@Nonnull String var1) throws ValidationException;

    public void validateDirPath(@Nonnull String var1) throws ValidationException;

    @Nonnull
    public static List<String> getAllAvailableProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerPluginManager.getInstance().get(FileServiceForTaskPlanner.class);
        for (FileServiceForTaskPlanner fileServiceForTaskPlanner : list) {
            arrayList.add(fileServiceForTaskPlanner.getExtensionName());
        }
        Collections.sort(arrayList, (string, string2) -> {
            if ("file".equalsIgnoreCase((String)string)) {
                return 1;
            }
            if ("file".equalsIgnoreCase((String)string2)) {
                return -1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        });
        return arrayList;
    }

    @Nullable
    public static FileServiceForTaskPlanner getServiceFor(@Nonnull String destination) {
        List list = ServerPluginManager.getInstance().get(FileServiceForTaskPlanner.class);
        FileServiceForTaskPlanner fileServiceForTaskPlanner = null;
        for (FileServiceForTaskPlanner fileServiceForTaskPlanner2 : list) {
            if (destination.startsWith(fileServiceForTaskPlanner2.getExtensionName())) {
                return fileServiceForTaskPlanner2;
            }
            if (!Objects.equals("file", fileServiceForTaskPlanner2.getExtensionName())) continue;
            fileServiceForTaskPlanner = fileServiceForTaskPlanner2;
        }
        return fileServiceForTaskPlanner;
    }
}

