/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.field;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.filechooser.FileSystemService;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldType;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@JsonData
@PublicApi
public class FolderField
extends Field {
    public static final String PROTOCOL_FILE = "file";
    private List<String> protocols;

    public FolderField(String key, String label) {
        super(FieldType.FOLDER, key, label);
        this.setProtocols(Arrays.asList(PROTOCOL_FILE));
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public String patchSeriesPlaceholderInValue(String value, Map<String, String> seriesProperties) {
        return this.replaceSeriesPlaceholders(value, seriesProperties);
    }

    @Override
    public String patchResultPlaceholderInValue(String value, List<JobResultContainer> results) {
        if (value == null) {
            return value;
        }
        return new PlaceholderResolver(value).addMetaData(results).resolve();
    }

    public static List<String> getAllAvailableProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerPluginManager.getInstance().get(FileSystemService.class);
        for (FileSystemService fileSystemService : list) {
            arrayList.add(fileSystemService.getExtensionName());
        }
        Collections.sort(arrayList, new Comparator<String>(){

            public int a(String string, String string2) {
                if (FolderField.PROTOCOL_FILE.equalsIgnoreCase(string)) {
                    return 1;
                }
                if (FolderField.PROTOCOL_FILE.equalsIgnoreCase(string2)) {
                    return -1;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((String)object, (String)object2);
            }
        });
        return arrayList;
    }
}

