/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid.viewtask;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ExecutionQualification;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(description="Container for information about a single result action.")
@JsonData
public class ResultActionDescription {
    @Schema(description="Unique identifier of the result action.", example="action123")
    private String id;
    @Schema(description="Properties of the result action.")
    private Map<String, String> properties;
    @Schema(description="Execution qualification of the result action.", example="ALWAYS")
    private ExecutionQualification executionqualification = ExecutionQualification.ALWAYS;

    private ResultActionDescription() {
    }

    public static ResultActionDescription from(ResultActionDefinition definition) {
        ResultActionDescription resultActionDescription = new ResultActionDescription();
        resultActionDescription.id = definition.getExtensionName();
        resultActionDescription.properties = definition.getProperties();
        resultActionDescription.executionqualification = definition.getExecutionQualification();
        return resultActionDescription;
    }

    public static ResultActionDefinition toResultActionDefinition(ResultActionDescription description, GUID taskId, SeriesDefinition seriesDefinition) {
        ResultActionFactory resultActionFactory = (ResultActionFactory)ServerPluginManager.getInstance().getSingleInstanceByName(ResultActionFactory.class, description.id, false);
        ResultActionInfo resultActionInfo = (ResultActionInfo)resultActionFactory.getInformation(taskId);
        for (Field field : resultActionInfo.getFields()) {
            if (description.properties.containsKey(field.getKey())) continue;
            description.properties.put(field.getKey(), field.getValue());
        }
        ResultActionDefinition resultActionDefinition = new ResultActionDefinition(description.id, description.properties);
        resultActionDefinition.setExecutionQualification(description.executionqualification);
        try {
            resultActionFactory.validate(resultActionDefinition, seriesDefinition, taskId);
        }
        catch (ValidationException validationException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)validationException);
            throw new ClientMessageException(validationException.getMessage());
        }
        return resultActionDefinition;
    }
}

