/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid;

import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.plugin.webapi.api.handler.RequestHandlerWithGUIDPathToken;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.internalapi.TaskPlannerForUsers;
import com.inet.taskplanner.webapi.handler.a;
import com.inet.taskplanner.webapi.handler.guid.viewtask.TaskDescription;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Description(description="Show the task description for the selected task planner task.", summary="Show task details")
public class b
extends RequestHandlerWithGUIDPathToken<Void, TaskDescription> {
    public b() {
        super(new String[]{"task"});
        TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
        this.registerRequestHandler((RequestHandlerBase)new com.inet.taskplanner.webapi.handler.guid.a("activate", "taskplanner-webapi.taskid.activation", gUID -> taskPlannerForUsers.activateTask((GUID)gUID)));
        this.registerRequestHandler((RequestHandlerBase)new com.inet.taskplanner.webapi.handler.guid.a("deactivate", "taskplanner-webapi.taskid.deactivation", gUID -> taskPlannerForUsers.deactivateTask((GUID)gUID)));
        this.registerRequestHandler((RequestHandlerBase)new com.inet.taskplanner.webapi.handler.guid.a("delete", "taskplanner-webapi.taskid.delete", gUID -> taskPlannerForUsers.removeTask((GUID)gUID)));
        this.registerRequestHandler((RequestHandlerBase)new com.inet.taskplanner.webapi.handler.guid.a("execute", "taskplanner-webapi.taskid.execute", gUID -> taskPlannerForUsers.executeTask((GUID)gUID)));
    }

    @Operation(summary="View Task Details", description="Provides detailed information about a specific task identified by its GUID.", responses={@ApiResponse(responseCode="200", description="Task details retrieved successfully", content={@Content(schema=@Schema(implementation=TaskDescription.class), examples={@ExampleObject(name="Task Description", summary="A detailed description of a task", value="{\"id\":\"b6nmv97sutmnvhtw8hen0yh7y\",\"name\":\"Sample Task\",\"description\":\"This is a sample task.\"}")})}), @ApiResponse(responseCode="404", description="The task id was not given or not found")})
    @ApiResponse(responseCode="404", description="The task id was not given or not found")
    public TaskDescription a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Void void_, @Nullable GUID gUID, boolean bl) throws IOException {
        if (gUID == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse);
            return null;
        }
        TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
        TaskDefinition taskDefinition = taskPlannerForUsers.getTaskDefinition(gUID);
        TaskExecution taskExecution = taskPlannerForUsers.getTaskExecution(gUID);
        if (taskDefinition == null || taskExecution == null) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse);
            return null;
        }
        a.o(gUID);
        return TaskDescription.from(taskDefinition, taskExecution);
    }

    public String getHelpPageKey() {
        return "taskplanner-webapi.taskid";
    }

    @Operation(summary="View Task Details", description="Provides detailed information about a specific task identified by its GUID.", responses={@ApiResponse(responseCode="200", description="Task details retrieved successfully", content={@Content(schema=@Schema(implementation=TaskDescription.class), examples={@ExampleObject(name="Task Description", summary="A detailed description of a task", value="{\"id\":\"b6nmv97sutmnvhtw8hen0yh7y\",\"name\":\"Sample Task\",\"description\":\"This is a sample task.\"}")})}), @ApiResponse(responseCode="404", description="The task id was not given or not found")})
    @ApiResponse(responseCode="404", description="The task id was not given or not found")
    public /* synthetic */ Object handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @Nullable Object object, @Nullable Object object2, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, (GUID)object2, bl);
    }
}

