/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler;

import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.annotation.Description;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.taskplanner.server.internalapi.TaskPlannerForUsers;
import com.inet.taskplanner.server.internalapi.TaskShortDescription;
import com.inet.taskplanner.webapi.handler.a;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Description(description="List tasks that belong to the user. May also be called with an /all parameter to show all tasks, if the user has the appropriate permissions", summary="List tasks of the user")
public class d
extends RequestHandler<Void, List<TaskShortDescription>> {
    private static final String[] cQ = new String[]{"list"};
    private static final String[] cR = new String[]{"list", "all"};
    private boolean cS;

    public d(boolean bl) {
        super(bl ? cR : cQ);
        this.cS = bl;
    }

    @Operation(summary="List Tasks", description="Lists tasks that belong to the user. May also list all tasks if the user has the appropriate permissions.", responses={@ApiResponse(responseCode="200", description="Tasks listed successfully", content={@Content(schema=@Schema(implementation=TaskShortDescription[].class), examples={@ExampleObject(name="Task List", summary="A List of Task Short Descriptions", value="[{\"taskId\":\"b6nmv97sutmnvhtw8hen0yh7y\",\"taskName\":\"Sample Task\"}]")})}), @ApiResponse(responseCode="403", description="User does not have permission to list tasks.")})
    public List<TaskShortDescription> a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl) throws IOException {
        if (!httpServletRequest.getParameterMap().isEmpty()) {
            ResponseWriter.notFound((HttpServletResponse)httpServletResponse);
            return null;
        }
        return this.a(httpServletResponse, this.cS);
    }

    private List<TaskShortDescription> a(HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        TaskPlannerForUsers taskPlannerForUsers = TaskPlannerForUsers.getInstance();
        List<TaskShortDescription> list = bl ? taskPlannerForUsers.listAllTasks() : taskPlannerForUsers.listUserTasks();
        Collections.sort(list, (taskShortDescription, taskShortDescription2) -> taskShortDescription.getId().compareTo(taskShortDescription2.getId()));
        list.forEach(taskShortDescription -> a.o(GUID.valueOf((String)taskShortDescription.getId())));
        return list;
    }

    public String getHelpPageKey() {
        return "taskplanner-webapi.list" + (this.cS ? "all" : "");
    }

    @Operation(summary="List Tasks", description="Lists tasks that belong to the user. May also list all tasks if the user has the appropriate permissions.", responses={@ApiResponse(responseCode="200", description="Tasks listed successfully", content={@Content(schema=@Schema(implementation=TaskShortDescription[].class), examples={@ExampleObject(name="Task List", summary="A List of Task Short Descriptions", value="[{\"taskId\":\"b6nmv97sutmnvhtw8hen0yh7y\",\"taskName\":\"Sample Task\"}]")})}), @ApiResponse(responseCode="403", description="User does not have permission to list tasks.")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, bl);
    }
}

