/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.series.json;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.taskplanner.server.api.series.json.a;
import java.net.URL;
import java.util.ArrayList;

@PublicApi
public class JsonSeriesFactory
extends SeriesFactory<a> {
    public static final String PROPERTY_FILE = "file";

    public JsonSeriesFactory() {
        super("series.json");
    }

    @Override
    public SeriesInfo getInformation(GUID taskID) {
        URL uRL = this.getClass().getResource("json.png");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        FileField fileField = new FileField(PROPERTY_FILE, TaskPlannerServerPlugin.MSG.getMsg("series.json.file", new Object[0]));
        fileField.setProtocols(FileField.getAllAvailableProtocols());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("*.json");
        arrayList2.add("*.txt");
        arrayList2.add("*.*");
        fileField.setFilter(arrayList2);
        arrayList.add(fileField);
        SeriesInfo seriesInfo = new SeriesInfo(this.getExtensionName(), TaskPlannerServerPlugin.MSG.getMsg("series.json.displayname", new Object[0]), TaskPlannerServerPlugin.MSG.getMsg("series.json.description", new Object[0]), uRL, "taskplanner.series.json", arrayList);
        return seriesInfo;
    }

    @Override
    public void validate(SeriesDefinition definition, GUID taskID) throws ValidationException {
        String string = definition.getProperty(PROPERTY_FILE);
        if (string == null || string.isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("series.json.nofile", new Object[0])});
        }
        try {
            new a(string).iterator();
        }
        catch (Throwable throwable) {
            ValidationException validationException = new ValidationException(new String[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)});
            validationException.initCause(throwable);
            throw validationException;
        }
    }

    @Override
    protected a createInstanceFrom(SeriesDefinition definition, GUID taskID) {
        return new a(definition.getProperty(PROPERTY_FILE));
    }

    @Override
    public SummaryInfo getSummary(SeriesDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string = definition.getProperty(PROPERTY_FILE);
        if (string != null && !string.isEmpty()) {
            arrayList.add(new SummaryEntry(null, string));
        }
        return new SummaryInfo(arrayList);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

