/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.taskplanner;

import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.url.URLPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.ReportException;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.doc.CellDistribution;
import com.inet.report.taskplanner.PromptDescription;
import com.inet.report.taskplanner.PromptsField;
import com.inet.report.taskplanner.a;
import com.inet.report.taskplanner.c;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.ColorField;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.field.PasswordField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class ReportJobFactory
extends JobFactory<c> {
    public static final String EXTENSION = "report";
    public static final String PROMPTS = "prompts";

    public ReportJobFactory() {
        super(EXTENSION);
    }

    public JobInfo getInformation(@Nullable GUID taskID) {
        TaskDefinition taskDefinition;
        Object object;
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/inet/report/taskplanner/reporting_32.png");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        SelectField selectField = ReportJobFactory.a(arrayList, "export_fmt", (List<FieldCondition>)null, "pdf", "htm", "htm.zip", "txt", "docx", "rtf", "java", "xlsx", "ods", "csv", "json", "jpg", "png", "svg", "ps3", "xml", "email");
        FileField fileField = new FileField("reports", c.k.getMsg("reportfile", new Object[0]));
        fileField.setProtocols(FileField.getAllAvailableProtocols());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("*.rpt");
        arrayList2.add("*.*");
        fileField.setFilter(arrayList2);
        fileField.setUpdateValuesOnChange(true);
        arrayList.add((Field)fileField);
        ReportJobFactory.a(arrayList, "navview", (Field)selectField, "pdf", "none", "bookmarks", "pages");
        ReportJobFactory.a(arrayList, "pdftags", (Field)selectField, "pdf", "false", "true");
        SelectField selectField2 = ReportJobFactory.a(arrayList, "pdf_extended", (Field)selectField, "pdf", "none", "pdfa", "fastwebview", "encrypted");
        ReportJobFactory.a(arrayList, "upass", (Field)selectField2, "encrypted");
        ReportJobFactory.a(arrayList, "opass", (Field)selectField2, "encrypted");
        ReportJobFactory.a(arrayList, "layout", (Field)selectField, "htm", "multipage", "single", "concat");
        ReportJobFactory.a(arrayList, "layout", (Field)selectField, "htm.zip", "multipage", "single", "concat");
        List<FieldCondition> list = Arrays.asList(FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"txt"), FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"csv"));
        ReportJobFactory.a(arrayList, "csv_type", (Field)selectField, "csv", "dataAndLabels", "dataOnly", "dataOnlyColumnnames");
        ReportJobFactory.a(arrayList, "quotechar", (Field)selectField, "csv", "\"");
        ReportJobFactory.a(arrayList, "newline", list, "windows", "macos", "unix");
        ReportJobFactory.a(arrayList, "encoding", list, "UTF-8");
        selectField2 = ReportJobFactory.a(arrayList, "delimiter_type", (Field)selectField, "csv", new ArrayList<LocalizedKey>(){
            {
                this.add(ReportJobFactory.a(","));
                this.add(ReportJobFactory.a(";"));
                this.add(ReportJobFactory.a("\t", "tab"));
                this.add(ReportJobFactory.a("other"));
                this.add(ReportJobFactory.a("fix"));
            }
        });
        ReportJobFactory.a(arrayList, "delimiter", (Field)selectField2, "other", ",");
        ReportJobFactory.a(arrayList, "colswidth", (Field)selectField2, "fix", null);
        selectField2 = ReportJobFactory.a(arrayList, "pagebreak_type", (Field)selectField, "txt", "line", "form_feed", "other");
        ReportJobFactory.a(arrayList, "pagebreak", (Field)selectField2, "other", null);
        ReportJobFactory.b(arrayList, "editable", (Field)selectField, "rtf", "false");
        ReportJobFactory.b(arrayList, "editable", (Field)selectField, "docx", "false");
        list = Arrays.asList(FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"xlsx"), FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"ods"));
        ReportJobFactory.b(arrayList, "celltruncate", list, "true");
        ReportJobFactory.a(arrayList, "celldistribution", list, (String[])Arrays.stream(CellDistribution.values()).map(Enum::name).toArray(String[]::new));
        ReportJobFactory.b(arrayList, "firstgroupassheets", list, "false");
        ArrayList<Object> arrayList3 = new ArrayList<LocalizedKey>();
        for (String string : new String[]{"0", "1", "2", "3", "4", "5", "6", "7"}) {
            arrayList3.add(new LocalizedKey(string, string));
        }
        ReportJobFactory.a(arrayList, "grouplevel", list, arrayList3);
        list = Arrays.asList(FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"jpg"), FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"png"));
        ReportJobFactory.c(arrayList, "background", list, "#FFFFFF");
        selectField2 = ReportJobFactory.a(arrayList, "zoom_type", list, "zoom", "width", "height");
        ReportJobFactory.a(arrayList, "zoom", (Field)selectField2, "zoom", "100%");
        ReportJobFactory.a(arrayList, "width", (Field)selectField2, "width", null);
        ReportJobFactory.a(arrayList, "height", (Field)selectField2, "height", null);
        ReportJobFactory.a(arrayList, "formula", null, null);
        List<String> list2 = a.a.getDataSourceNames();
        arrayList3 = new ArrayList();
        arrayList3.add(new LocalizedKey("", ""));
        for (String string : list2) {
            arrayList3.add(new LocalizedKey(string, string));
        }
        if (list2.isEmpty()) {
            object = new SelectField("datasource", c.k.getMsg("datasource", new Object[0]), arrayList3);
            list = list2.isEmpty() ? Arrays.asList(FieldCondition.visible((Field)object, (FieldCondition.OP)FieldCondition.OP.notequal, (String)"")) : null;
        } else {
            list = null;
        }
        ReportJobFactory.a(arrayList, "datasource", list, arrayList3);
        PromptsField promptsField = new PromptsField(PROMPTS, null);
        promptsField.setValue("[]");
        arrayList.add(promptsField);
        object = new ArrayList();
        SelectField selectField3 = ReportJobFactory.a((List<Field>)object, "template", (List<FieldCondition>)null, "notEmptyReport", "emptyReport", "formula");
        ReportJobFactory.a((List<Field>)object, "formula", (Field)selectField3, "formula", null);
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        arrayList4.add("report.path");
        arrayList4.add("report.title");
        arrayList4.add("report.pages");
        arrayList4.add("report.formula");
        if (taskID != null && (taskDefinition = TaskPlanner.getInstance().getTaskDefinition(taskID)) != null) {
            for (JobDefinition jobDefinition : taskDefinition.getJobs()) {
                PromptDescription[] promptDescriptionArray;
                if (!EXTENSION.equals(jobDefinition.getExtensionName())) continue;
                Map map = jobDefinition.getProperties();
                String string = map.getOrDefault(PROMPTS, "[]");
                for (PromptDescription promptDescription : promptDescriptionArray = (PromptDescription[])new Json().fromJson(string, PromptDescription[].class, new HashMap())) {
                    arrayList4.add("prompt." + promptDescription.getKey());
                }
            }
        }
        taskDefinition = new JobInfo(this.getExtensionName(), c.k.getMsg("job.displayname", new Object[0]), c.k.getMsg("job.description", new Object[0]), uRL, "taskplanner.job.reporting", new ConditionInfo((List)object), arrayList, arrayList4);
        return taskDefinition;
    }

    private static TextField a(List<Field> list, String string, Field field, String string2, String string3) {
        return ReportJobFactory.a(list, string, Arrays.asList(FieldCondition.visible((Field)field, (FieldCondition.OP)FieldCondition.OP.equals, (String)string2)), string3);
    }

    private static TextField a(List<Field> list, String string, List<FieldCondition> list2, String string2) {
        TextField textField = new TextField(string, c.k.getMsg(string, new Object[0]));
        textField.setConditions(list2);
        textField.setValue(string2);
        list.add((Field)textField);
        return textField;
    }

    private static BooleanField b(List<Field> list, String string, Field field, String string2, String string3) {
        return ReportJobFactory.b(list, string, Arrays.asList(FieldCondition.visible((Field)field, (FieldCondition.OP)FieldCondition.OP.equals, (String)string2)), string3);
    }

    private static BooleanField b(List<Field> list, String string, List<FieldCondition> list2, String string2) {
        BooleanField booleanField = new BooleanField(string, c.k.getMsg(string, new Object[0]));
        booleanField.setConditions(list2);
        booleanField.setValue(string2);
        list.add((Field)booleanField);
        return booleanField;
    }

    private static ColorField c(List<Field> list, String string, List<FieldCondition> list2, String string2) {
        ColorField colorField = new ColorField(string, c.k.getMsg(string, new Object[0]));
        colorField.setConditions(list2);
        colorField.setValue(string2);
        list.add((Field)colorField);
        return colorField;
    }

    private static PasswordField a(List<Field> list, String string, Field field, String string2) {
        PasswordField passwordField = new PasswordField(string, c.k.getMsg(string, new Object[0]));
        passwordField.setConditions(Arrays.asList(FieldCondition.visible((Field)field, (FieldCondition.OP)FieldCondition.OP.equals, (String)string2)));
        list.add((Field)passwordField);
        return passwordField;
    }

    private static SelectField a(List<Field> list, String string, Field field, String string2, String ... stringArray) {
        return ReportJobFactory.a(list, string, Arrays.asList(FieldCondition.visible((Field)field, (FieldCondition.OP)FieldCondition.OP.equals, (String)string2)), stringArray);
    }

    private static SelectField a(List<Field> list, String string, Field field, String string2, ArrayList<LocalizedKey> arrayList) {
        return ReportJobFactory.a(list, string, Arrays.asList(FieldCondition.visible((Field)field, (FieldCondition.OP)FieldCondition.OP.equals, (String)string2)), arrayList);
    }

    private static SelectField a(List<Field> list, String string, List<FieldCondition> list2, String ... stringArray) {
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        for (String string2 : stringArray) {
            arrayList.add(ReportJobFactory.a(string2));
        }
        return ReportJobFactory.a(list, string, list2, arrayList);
    }

    private static SelectField a(List<Field> list, String string, List<FieldCondition> list2, ArrayList<LocalizedKey> arrayList) {
        SelectField selectField = new SelectField(string, c.k.getMsg(string, new Object[0]), arrayList);
        selectField.setConditions(list2);
        selectField.setValue(arrayList.get(0).getKey());
        list.add((Field)selectField);
        return selectField;
    }

    public Map<String, String> updateValues(JobDefinition patchedDefinition, JobDefinition unpatchedDefinition, SeriesDefinition seriesDefinition, GUID taskID) {
        Map map;
        JobDefinition jobDefinition = unpatchedDefinition != null ? unpatchedDefinition : patchedDefinition;
        Map map2 = jobDefinition.getProperties();
        String string = map2.getOrDefault("reports", "");
        String string2 = map2.getOrDefault("reports.old", "");
        String string3 = map2.getOrDefault("version", "1");
        if (!string2.isEmpty() && Integer.parseInt(string3) < 2) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ReportJobFactory.a(map2, hashMap);
            hashMap.put("version", "2");
            return hashMap;
        }
        if (Objects.equals(string, string2)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set set = null;
        if (seriesDefinition != null) {
            try {
                set = seriesDefinition.getCachedKeys();
                if (set == null) {
                    map = (SeriesFactory)ServerPluginManager.getInstance().getSingleInstanceByName(SeriesFactory.class, seriesDefinition.getExtensionName(), false);
                    set = map.getKeys(seriesDefinition);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        map = jobDefinition.getProperties();
        String string4 = map.getOrDefault(PROMPTS, "[]");
        PromptDescription[] promptDescriptionArray = (PromptDescription[])new Json().fromJson(string4, PromptDescription[].class, new HashMap());
        for (PromptDescription object : promptDescriptionArray) {
            hashMap.put(object.getKey(), object.getValue());
        }
        HashMap hashMap2 = new HashMap();
        hashMap2.put("version", "2");
        try {
            jobDefinition.removeProperty(PROMPTS);
            c c2 = new c(jobDefinition, false);
            Prompt[] promptArray = c2.e();
            ArrayList<PromptDescription> arrayList = new ArrayList<PromptDescription>();
            for (Prompt prompt : promptArray) {
                Object object;
                if (prompt.isNotUsed()) continue;
                String[] stringArray = prompt.getDefaultValues();
                if (!prompt.isEditable() && stringArray != null && stringArray.length == 1 && StringFunctions.isEmpty((String)(object = prompt.getCascadingParent()))) {
                    boolean promptDescription = true;
                    String string5 = prompt.getName();
                    for (Prompt prompt2 : promptArray) {
                        if (!string5.equals(prompt2.getCascadingParent())) continue;
                        promptDescription = false;
                        break;
                    }
                    if (promptDescription) continue;
                }
                object = prompt.getValue();
                if (hashMap.containsKey(prompt.getName())) {
                    object = (String)hashMap.get(prompt.getName());
                } else if (set != null && set.contains(prompt.getName())) {
                    object = "{" + prompt.getName() + "}";
                    if (prompt.getValueType() == 11) {
                        object = "'" + PromptsField.duplicateQuote((String)object) + "'";
                    }
                }
                if (object == null) {
                    object = "";
                }
                PromptDescription promptDescription = new PromptDescription(prompt.getName(), prompt.getDisplayName(), prompt.getValueType(), (String)object);
                arrayList.add(promptDescription);
            }
            hashMap2.put(PROMPTS, new Json().toJson(arrayList));
            hashMap2.put("reports.old", string);
            hashMap2.put("report.title", c2.d());
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        return hashMap2;
    }

    private static void a(Map<String, String> map, Map<String, String> map2) {
        boolean bl = false;
        String string = map.getOrDefault(PROMPTS, "[]");
        PromptDescription[] promptDescriptionArray = (PromptDescription[])new Json().fromJson(string, PromptDescription[].class, new HashMap());
        for (int i = 0; i < promptDescriptionArray.length; ++i) {
            PromptDescription promptDescription = promptDescriptionArray[i];
            String string2 = promptDescription.getValue();
            if (string2 == null) continue;
            if (promptDescription.getType() == 11) {
                if (string2.startsWith("[") && string2.endsWith("]")) {
                    promptDescription.setValue(string2.replace('\"', '\''));
                    bl = true;
                    continue;
                }
                if (string2.startsWith("'") || string2.endsWith("'")) continue;
                promptDescription.setValue("'" + PromptsField.duplicateQuote(string2) + "'");
                bl = true;
                continue;
            }
            if (!string2.toLowerCase().startsWith("formula:")) continue;
            promptDescription.setValue(string2.substring(8));
            bl = true;
        }
        if (bl) {
            map2.put(PROMPTS, new Json().toJson((Object)promptDescriptionArray));
        }
    }

    private static LocalizedKey a(@Nonnull String string) {
        return new LocalizedKey(string, c.k.getMsg(string, new Object[0]));
    }

    private static LocalizedKey a(@Nonnull String string, String string2) {
        return new LocalizedKey(string, c.k.getMsg(string2, new Object[0]));
    }

    public void validate(@Nonnull JobDefinition definition, @Nullable GUID taskID) throws ValidationException {
        new c(definition, true).f();
    }

    public void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
        new c(definition, true).f();
    }

    protected c createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new c(definition, false);
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        Map map = definition.getProperties();
        String string = (String)map.get("export_fmt");
        if (!StringFunctions.isEmpty((String)string)) {
            arrayList.add(new SummaryEntry(c.k.getMsg("export_fmt", new Object[0]), c.k.getMsg(string, new Object[0])));
        }
        if (!StringFunctions.isEmpty((String)(string = (String)map.get("reports")))) {
            arrayList.add(new SummaryEntry(c.k.getMsg("reportfile", new Object[0]), string));
        }
        if (!StringFunctions.isEmpty((String)(string = (String)map.get("report.title")))) {
            arrayList.add(new SummaryEntry(c.k.getMsg("report.title", new Object[0]), string));
        }
        ArrayList<SummaryEntry> arrayList2 = null;
        ConditionDefinition conditionDefinition = definition.getCondition();
        if (conditionDefinition != null) {
            String string2 = null;
            String string3 = (String)conditionDefinition.getProperties().get("template");
            if (!StringFunctions.isEmpty((String)string3)) {
                switch (string3) {
                    case "notEmptyReport": 
                    case "emptyReport": {
                        string2 = c.k.getMsg(string3, new Object[0]);
                        break;
                    }
                    default: {
                        string2 = ReportJobFactory.d(conditionDefinition.getProperties());
                    }
                }
            }
            if (string2 != null) {
                arrayList2 = new ArrayList<SummaryEntry>();
                arrayList2.add(new SummaryEntry(c.k.getMsg("condition", new Object[0]), string2));
            }
        }
        if (!StringFunctions.isEmpty((String)(string = (String)map.get("datasource")))) {
            arrayList.add(new SummaryEntry(c.k.getMsg("datasource", new Object[0]), string));
        }
        return new JobSummaryInfo(arrayList, arrayList2);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        String string = definition.getProperty("export_fmt");
        if (string == null) {
            return Arrays.asList(ResultFlavor.FILE);
        }
        switch (string) {
            case "java": {
                return Arrays.asList(ResultFlavor.PRINT);
            }
            case "txt": 
            case "email": {
                return Arrays.asList(ResultFlavor.FILE, ResultFlavor.TEXT);
            }
            case "htm": {
                String string2 = definition.getProperty("layout");
                if (StringFunctions.isEmpty((String)string2)) break;
                return Arrays.asList(ResultFlavor.FILE, ResultFlavor.TEXT);
            }
        }
        return Arrays.asList(ResultFlavor.FILE);
    }

    @Nullable
    static String d(@Nullable Map<String, String> map) {
        if (map == null) {
            return null;
        }
        String string = map.get("template");
        if (StringFunctions.isEmpty((String)string)) {
            return null;
        }
        switch (string) {
            case "notEmptyReport": {
                return "RecordCount > 0";
            }
            case "emptyReport": {
                return "RecordCount = 0";
            }
            case "formula": {
                String string2 = map.get("formula");
                if (StringFunctions.isEmpty((String)string2)) break;
                return string2;
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean isAvailable() {
        @Nonnull List list = ServerPluginManager.getInstance().get(FileServiceForTaskPlanner.class);
        for (FileServiceForTaskPlanner fileServiceForTaskPlanner : list) {
            Permission permission = fileServiceForTaskPlanner.getRequiredPermission();
            if (permission != null && !SystemPermissionChecker.checkAccess((Permission)permission)) continue;
            return true;
        }
        try {
            URLPermissionChecker.checkReportLocation((URL)new URL("http://"));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

