/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.taskplanner.job;

import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.pdfc.plugin.persistence.ProfilePersistence;
import com.inet.pdfc.plugin.persistence.ProfilePersistenceManager;
import com.inet.pdfc.taskplanner.job.c;
import com.inet.pdfc.taskplanner.result.e;
import com.inet.pdfc.taskplanner.result.j;
import com.inet.pdfc.taskplanner.utils.b;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class ComparisonJobFactory
extends JobFactory<c> {
    static final List<ResultFlavor> I = new ArrayList<ResultFlavor>(){
        {
            this.add(ResultFlavor.FILE);
            this.addAll(e.aq);
            this.addAll(j.I);
        }
    };
    public static final String KEY_PROFILE = "comparison.profile";
    public static final String KEY_EXPORT_FORMAT = "comparison.exportformat";
    public static final String KEY_COLLAPSE_PAGES = "comparison.collapse";
    public static final String KEY_PDF_FOR_NO_DIFFS = "comparison.pdffornodiffs";
    public static final String KEY_DETAILED_REPORT = "comparison.detailed";
    public static final String KEY_REPORT_SHOW_DIAGRAMS = "comparison.showDiagrams";
    public static final String KEY_APPEND_SETTINGS = "comparison.appendSettings";
    public static final String PLACEHOLDER_DIFFERENCES = "comparison.differences";
    public static final String CONDITION_DIFFERENCES = "comparison.differences";
    public static final String KEY_EXPORT_PAGEFORMAT = "comparison.export.pageformat";
    public static final String KEY_EXPORT_ORIENTATION = "comparison.export.orientation";
    public static final String KEY_EXPORT_DOCUMENTS = "comparison.export.documents";
    public static final String KEY_EXPORT_SCALETOFIT = "comparison.export.scaletofit";
    public static final String KEY_EXPORT_HEADERFOOTER = "comparison.export.headerfooter";
    public static final String KEY_EXPORT_COMMENTS = "comparison.export.comments";
    public static final String KEY_EXPORT_MARKUP = "comparison.export.markup";
    public static final String KEY_EXPORT_REPORT_FORMAT = "comparison.export.report.format";
    public static final String KEY_EXPORT_PDF_FONT_EMBEDDING = "comparison.export.pdf.fontebedding";

    ComparisonJobFactory(@Nonnull String extensionName) {
        super(extensionName);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        HashSet<ResultFlavor> hashSet = new HashSet<ResultFlavor>();
        if (definition == null) {
            hashSet.addAll(I);
        } else {
            c c2 = (c)((Object)this.createInstanceFrom((AbstractDefinition)definition, null));
            if (c2 != null) {
                hashSet.addAll(c2.d());
            } else {
                hashSet.addAll(I);
            }
            try {
                String string = definition.getProperty(KEY_EXPORT_FORMAT);
                EXPORT eXPORT = EXPORT.valueOf(string);
                switch (eXPORT) {
                    case pdf: 
                    case images: {
                        hashSet.add(ResultFlavor.PRINT);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<ResultFlavor>(hashSet);
    }

    protected void validateCondition(JobDefinition definition) throws ValidationException {
        ((c)((Object)this.createInstanceFrom((AbstractDefinition)definition, null))).e();
    }

    protected void validate(JobDefinition definition, GUID taskID) throws ValidationException {
        ((c)((Object)this.createInstanceFrom((AbstractDefinition)definition, taskID))).c();
    }

    public JobSummaryInfo getSummary(JobDefinition definition) {
        return ((c)((Object)this.createInstanceFrom((AbstractDefinition)definition, null))).b();
    }

    public Map<String, String> updateValues(JobDefinition patchedDefinition, JobDefinition unpatchedDefinition, SeriesDefinition seriesDefinition, GUID taskID) {
        String string = patchedDefinition.getProperty(KEY_COLLAPSE_PAGES);
        String string2 = patchedDefinition.getProperty("comparison.collapse.print");
        if (string != null ? string.equals(string2) : string2 == null) {
            return null;
        }
        String string3 = patchedDefinition.getProperty(KEY_EXPORT_FORMAT);
        EXPORT eXPORT = EXPORT.pdf;
        try {
            eXPORT = EXPORT.valueOf(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        switch (eXPORT) {
            case pdf: 
            case images: {
                hashMap.put("comparison.collapse.print", string);
                break;
            }
            default: {
                hashMap.put(KEY_COLLAPSE_PAGES, string2);
            }
        }
        return hashMap;
    }

    @Nonnull
    protected SelectField createExportField() {
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        for (EXPORT eXPORT : EXPORT.values()) {
            arrayList.add(new LocalizedKey(eXPORT.name(), b.a("format." + String.valueOf((Object)eXPORT), new Object[0])));
        }
        SelectField selectField = new SelectField(KEY_EXPORT_FORMAT, b.a("export.format", new Object[0]), arrayList);
        selectField.setValue(EXPORT.pdf.name());
        return selectField;
    }

    protected BooleanField createBtnCollapsePages(SelectField export, boolean print) {
        BooleanField booleanField = new BooleanField(print ? "comparison.collapse.print" : KEY_COLLAPSE_PAGES, "", b.a("export.collapsePages" + (print ? ".print" : ""), new Object[0]));
        booleanField.setUpdateValuesOnChange(true);
        ArrayList<FieldCondition> arrayList = new ArrayList<FieldCondition>();
        if (!print) {
            arrayList.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.pdf.name()));
            arrayList.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.images.name()));
        }
        booleanField.setConditions(arrayList);
        return booleanField;
    }

    protected void createSelectProfile(List<Field> fields) {
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        ProfilePersistenceManager profilePersistenceManager = (ProfilePersistenceManager)ServerPluginManager.getInstance().getSingleInstance(ProfilePersistenceManager.class);
        try {
            List list = profilePersistenceManager.getAllProfiles(UserManager.getInstance().getCurrentUserAccountID());
            for (ProfilePersistence profilePersistence : list) {
                arrayList.add(new LocalizedKey(profilePersistence.getGUID().toString(), profilePersistence.getName()));
            }
            SelectField selectField = new SelectField(KEY_PROFILE, b.a("profile", new Object[0]), arrayList);
            selectField.setValue(((ProfilePersistence)list.get(0)).getGUID().toString());
            fields.add((Field)selectField);
        }
        catch (IOException iOException) {
            TaskPlannerServerPlugin.LOGGER.error((Throwable)iOException);
        }
    }

    protected void createExportOptions(SelectField export, List<Field> fields) {
        ArrayList<FieldCondition> arrayList = new ArrayList<FieldCondition>();
        arrayList.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.pdf.name()));
        ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
        arrayList2.add(new LocalizedKey("auto", b.a("export.pageFormat.auto", new Object[0])));
        arrayList2.add(new LocalizedKey("a3", "A3 (ISO/DIN & JIS)"));
        arrayList2.add(new LocalizedKey("a4", "A4 (ISO/DIN & JIS)"));
        arrayList2.add(new LocalizedKey("a5", "A5 (ISO/DIN & JIS)"));
        arrayList2.add(new LocalizedKey("b4", "B4 (JIS)"));
        arrayList2.add(new LocalizedKey("b5", "B5 (JIS)"));
        arrayList2.add(new LocalizedKey("legal", "Legal"));
        arrayList2.add(new LocalizedKey("letter", "Letter"));
        SelectField selectField = new SelectField(KEY_EXPORT_PAGEFORMAT, b.a("export.pageFormat", new Object[0]), arrayList2);
        selectField.setValue("a4");
        selectField.setConditions(arrayList);
        fields.add((Field)selectField);
        ArrayList<FieldCondition> arrayList3 = new ArrayList<FieldCondition>();
        arrayList3.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.pdf.name()));
        arrayList3.add(FieldCondition.disabled((Field)selectField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"auto"));
        arrayList2 = new ArrayList();
        arrayList2.add(new LocalizedKey("landscape", b.a("export.orientation.landscape", new Object[0])));
        arrayList2.add(new LocalizedKey("portrait", b.a("export.orientation.portrait", new Object[0])));
        SelectField selectField2 = new SelectField(KEY_EXPORT_ORIENTATION, b.a("export.orientation", new Object[0]), arrayList2);
        selectField2.setConditions(arrayList3);
        selectField2.setValue("landscape");
        fields.add((Field)selectField2);
        arrayList2 = new ArrayList();
        SelectField selectField3 = new SelectField(KEY_EXPORT_DOCUMENTS, b.a("export.documents", new Object[0]), arrayList2);
        arrayList2.add(new LocalizedKey("both", b.a("export.documents.both", new Object[0])));
        arrayList2.add(new LocalizedKey("left", b.a("export.documents.left", new Object[0])));
        arrayList2.add(new LocalizedKey("right", b.a("export.documents.right", new Object[0])));
        selectField3.setConditions(arrayList);
        selectField3.setValue("both");
        fields.add((Field)selectField3);
        BooleanField booleanField = new BooleanField(KEY_EXPORT_HEADERFOOTER, "", b.a("export.headerFooter", new Object[0]));
        booleanField.setValue("true");
        booleanField.setConditions(arrayList);
        fields.add((Field)booleanField);
        BooleanField booleanField2 = new BooleanField(KEY_EXPORT_SCALETOFIT, "", b.a("export.scaleToFit", new Object[0]));
        booleanField2.setValue("true");
        arrayList3 = new ArrayList();
        arrayList3.add(FieldCondition.visible((Field)selectField, (FieldCondition.OP)FieldCondition.OP.notequal, (String)"auto"));
        booleanField2.setConditions(arrayList3);
        fields.add((Field)booleanField2);
        BooleanField booleanField3 = new BooleanField(KEY_EXPORT_COMMENTS, "", b.a("export.comments", new Object[0]));
        booleanField3.setValue("true");
        booleanField3.setConditions(arrayList);
        fields.add((Field)booleanField3);
        BooleanField booleanField4 = new BooleanField(KEY_EXPORT_MARKUP, "", b.a("export.markup", new Object[0]));
        booleanField4.setValue("true");
        arrayList = new ArrayList();
        arrayList.add(FieldCondition.visible((Field)selectField3, (FieldCondition.OP)FieldCondition.OP.equals, (String)"both"));
        booleanField4.setConditions(arrayList);
        fields.add((Field)booleanField4);
        BooleanField booleanField5 = new BooleanField(KEY_EXPORT_PDF_FONT_EMBEDDING, "", b.a("export.fontembedding", new Object[0]));
        booleanField5.setValue("true");
        booleanField5.setConditions(arrayList);
        fields.add((Field)booleanField5);
    }

    protected BooleanField createBtnDetailedReport(SelectField export) {
        BooleanField booleanField = new BooleanField(KEY_DETAILED_REPORT, "", b.a("export.appendDetails", new Object[0]));
        ArrayList<FieldCondition> arrayList = new ArrayList<FieldCondition>();
        arrayList.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.report.name()));
        booleanField.setConditions(arrayList);
        return booleanField;
    }

    protected BooleanField createBtnAppendSettings(SelectField export) {
        BooleanField booleanField = new BooleanField(KEY_APPEND_SETTINGS, "", b.a("export.appendSettings", new Object[0]));
        ArrayList<FieldCondition> arrayList = new ArrayList<FieldCondition>();
        arrayList.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.report.name()));
        booleanField.setConditions(arrayList);
        return booleanField;
    }

    protected SelectField createSelectReportFormat(SelectField export) {
        ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
        arrayList.add(new LocalizedKey("PDF", "PDF - Portable Document Format"));
        arrayList.add(new LocalizedKey("XLS", "XLS - Microsoft Excel (97 - 2003)"));
        arrayList.add(new LocalizedKey("XLSX", "XLSX - Microsoft Excel (2007 - )"));
        arrayList.add(new LocalizedKey("ODS", "ODS - Open Document Spreadsheet"));
        arrayList.add(new LocalizedKey("RTF", "RTF - Rich Text Format"));
        SelectField selectField = new SelectField(KEY_EXPORT_REPORT_FORMAT, b.a("export.reportFormat", new Object[0]), arrayList);
        selectField.setValue("PDF");
        ArrayList<FieldCondition> arrayList2 = new ArrayList<FieldCondition>();
        arrayList2.add(FieldCondition.visible((Field)export, (FieldCondition.OP)FieldCondition.OP.equals, (String)EXPORT.report.name()));
        selectField.setConditions(arrayList2);
        return selectField;
    }

    protected List<String> createPlaceholders(String ... additional) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(KEY_EXPORT_FORMAT);
        arrayList.add(KEY_PROFILE);
        arrayList.addAll(Arrays.asList(additional));
        return arrayList;
    }

    @PublicApi
    public static final class EXPORT
    extends Enum<EXPORT> {
        public static final /* enum */ EXPORT pdf = new EXPORT();
        public static final /* enum */ EXPORT images = new EXPORT();
        public static final /* enum */ EXPORT report = new EXPORT();
        public static final /* enum */ EXPORT json = new EXPORT();
        public static final /* enum */ EXPORT text = new EXPORT();
        private static final /* synthetic */ EXPORT[] J;

        public static EXPORT[] values() {
            return (EXPORT[])J.clone();
        }

        public static EXPORT valueOf(String name) {
            return Enum.valueOf(EXPORT.class, name);
        }

        private static /* synthetic */ EXPORT[] B() {
            return new EXPORT[]{pdf, images, report, json, text};
        }

        static {
            J = EXPORT.B();
        }
    }
}

