/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.taskplanner.job;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.taskplanner.job.ComparisonJobFactory;
import com.inet.taskplanner.server.api.job.JobDefinition;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@PublicApi
public class ComparisonJobBuilder {
    private Map<String, String> G = new HashMap<String, String>();
    private String H;

    private ComparisonJobBuilder() {
    }

    @Nonnull
    public static ComparisonJobBuilder singleComparison(@Nonnull File first, @Nonnull File second) {
        ComparisonJobBuilder comparisonJobBuilder = new ComparisonJobBuilder();
        comparisonJobBuilder.G.put("comparison.document1", first.toString());
        comparisonJobBuilder.G.put("comparison.document2", second.toString());
        comparisonJobBuilder.H = "job.pdfc.comparison";
        return comparisonJobBuilder;
    }

    @Nonnull
    public static ComparisonJobBuilder singleComparison(@Nonnull URL first, @Nonnull URL second) {
        ComparisonJobBuilder comparisonJobBuilder = new ComparisonJobBuilder();
        comparisonJobBuilder.G.put("comparison.document1", first.toString());
        comparisonJobBuilder.G.put("comparison.document2", second.toString());
        comparisonJobBuilder.H = "job.pdfc.comparison";
        return comparisonJobBuilder;
    }

    @Nonnull
    public static ComparisonJobBuilder batchComparison(@Nonnull File firstFolder, @Nonnull File secondFolder) {
        ComparisonJobBuilder comparisonJobBuilder = new ComparisonJobBuilder();
        comparisonJobBuilder.G.put("comparison.folder1", firstFolder.toString());
        comparisonJobBuilder.G.put("comparison.folder2", secondFolder.toString());
        comparisonJobBuilder.H = "job.pdfc.batch";
        return comparisonJobBuilder;
    }

    @Nonnull
    public ComparisonJobBuilder withProfile(String profileID) {
        if (profileID != null) {
            this.G.put("comparison.profile", profileID);
        } else {
            this.G.remove("comparison.profile");
        }
        return this;
    }

    @Nonnull
    public ComparisonJobBuilder withExportFormat(String format) {
        try {
            ComparisonJobFactory.EXPORT.valueOf(format.toLowerCase());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(format + " is not a valid export format");
        }
        this.G.put("comparison.exportformat", format);
        return this;
    }

    @Nonnull
    public ComparisonJobBuilder collapseEqualPages() {
        this.G.put("comparison.collapse", "true");
        return this;
    }

    @Nonnull
    public ComparisonJobBuilder exportAlways() {
        this.G.put("comparison.pdffornodiffs", "true");
        return this;
    }

    @Nonnull
    public ComparisonJobBuilder appendDetailsToReport() {
        this.G.put("comparison.detailed", "true");
        return this;
    }

    @Nonnull
    public JobDefinition create() {
        return new JobDefinition(this.H, this.G);
    }
}

