/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.openweathermap;

import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.taskplanner.openweathermap.TaskPlannerOpenWeatherMapServerPlugin;
import com.inet.taskplanner.openweathermap.Units;
import com.inet.taskplanner.openweathermap.WeatherData;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import com.inet.taskplanner.server.api.result.StringTextResult;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class OpenWeatherMapJob
extends Job {
    private static final String API_URL = "https://api.openweathermap.org/data/2.5/";
    private String apiKey;
    private String location;
    private Units units = Units.DEFAULT;
    private double currentTemperature = 0.0;
    private boolean stopRequested = false;

    public OpenWeatherMapJob(String apiKey, String location, String units, ConditionDefinition condition) {
        super(condition);
        this.apiKey = apiKey;
        this.location = location;
        if (units != null) {
            try {
                this.units = Units.valueOf(units);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JobResultContainer run() throws TaskExecutionException {
        try {
            String cityAndCountry = "q=" + EncodingFunctions.encodeUrlParameter((String)this.location);
            String appID = "appid=" + EncodingFunctions.encodeUrlParameter((String)this.apiKey);
            String language = "lang=" + EncodingFunctions.encodeUrlParameter((String)ClientLocale.getThreadLocale().getLanguage().toLowerCase());
            String unitSettings = "units=" + EncodingFunctions.encodeUrlParameter((String)this.units.name().toLowerCase());
            URL target = new URL("https://api.openweathermap.org/data/2.5/weather?" + cityAndCountry + "&" + appID + "&" + language + "&" + unitSettings);
            if (this.stopRequested) {
                return null;
            }
            URLConnection connection = target.openConnection();
            try (InputStream inputStream = connection.getInputStream();){
                if (this.stopRequested) {
                    JobResultContainer jobResultContainer = null;
                    return jobResultContainer;
                }
                WeatherData weatherData = (WeatherData)new Json().fromJson(inputStream, WeatherData.class, new HashMap(), null);
                if (weatherData.getCod() != 200) {
                    throw new TaskExecutionException((Throwable)new IllegalArgumentException(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.errorcode", new Object[]{weatherData.getCod()})));
                }
                this.currentTemperature = weatherData.getMain().getTemp();
                DateFormat dateTimeFormat = SimpleDateFormat.getTimeInstance(3);
                String weather = weatherData.getWeather().get(0).getDescription();
                String temperature = String.format("%.2f", weatherData.getMain().getTemp()) + " " + this.units.getTemperatureUnit();
                String pressure = weatherData.getMain().getPressure() + " hPa";
                String humidity = weatherData.getMain().getHumidity() + "%";
                String windSpeed = weatherData.getWind().getSpeed() + " " + this.units.getSpeedUnit();
                String sunrise = dateTimeFormat.format(new Date(weatherData.getSys().getSunrise() * 1000L));
                String sunset = dateTimeFormat.format(new Date(weatherData.getSys().getSunset() * 1000L));
                StringBuilder text = new StringBuilder();
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.weather", new Object[0]) + ": " + weather);
                text.append("\r\n");
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.temp", new Object[0]) + ": " + temperature);
                text.append("\r\n");
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.pressure", new Object[0]) + ": " + pressure);
                text.append("\r\n");
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.humidity", new Object[0]) + ": " + humidity);
                text.append("\r\n");
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.wind", new Object[0]) + ": " + windSpeed);
                text.append("\r\n");
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.sunrise", new Object[0]) + ": " + sunrise);
                text.append("\r\n");
                text.append(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.details.sunset", new Object[0]) + ": " + sunset);
                text.append("\r\n");
                StringTextResult result = new StringTextResult(text.toString(), "text/plain");
                HashMap<String, Object> metaProperties = new HashMap<String, Object>();
                metaProperties.put("weather.city", weatherData.getName());
                metaProperties.put("weather.country", weatherData.getSys().getCountry());
                metaProperties.put("weather.description", weather);
                metaProperties.put("weather.temperature", temperature);
                metaProperties.put("weather.pressure", pressure);
                metaProperties.put("weather.humidity", humidity);
                metaProperties.put("weather.windspeed", windSpeed);
                metaProperties.put("weather.sunrise", sunrise);
                metaProperties.put("weather.sunset", sunset);
                ResultContainer resultContainer = new ResultContainer(Arrays.asList(result), metaProperties);
                return resultContainer;
            }
        }
        catch (Throwable t) {
            TaskPlannerOpenWeatherMapServerPlugin.LOGGER.error(t);
            throw new TaskExecutionException(t);
        }
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        String temperature = conditionDefinition.getProperty("temperature");
        try {
            double temp = Double.parseDouble(temperature);
            return this.currentTemperature > temp;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public void stopRequested() {
        this.stopRequested = true;
    }
}

