/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.openweathermap;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.taskplanner.openweathermap.OpenWeatherMapJob;
import com.inet.taskplanner.openweathermap.TaskPlannerOpenWeatherMapServerPlugin;
import com.inet.taskplanner.openweathermap.Units;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.LinkField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenWeatherMapJobFactory
extends JobFactory<OpenWeatherMapJob> {
    static final String PROPERTY_LOCATION = "location";
    static final String PROPERTY_APIKEY = "apikey";
    static final String PROPERTY_LINK = "link";
    static final String PROPERTY_UNITS = "units";
    static final String PROPERTY_TEMPERATURE = "temperature";

    public OpenWeatherMapJobFactory() {
        super("job.openweathermap");
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return Arrays.asList(ResultFlavor.TEXT);
    }

    public JobInfo getInformation(@Nullable GUID taskID) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/taskplanner/openweathermap/taskplanner_openweather_32.png");
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(new TextField(PROPERTY_APIKEY, TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.apikey", new Object[0])));
        fields.add(new LinkField(PROPERTY_LINK, "", TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.link", new Object[0]), TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.link.text", new Object[0])));
        TextField location = new TextField(PROPERTY_LOCATION, TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.location", new Object[0]));
        location.setPlaceholder(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.location.placeholder", new Object[0]));
        fields.add(location);
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        for (Units unit : Units.values()) {
            values.add(new LocalizedKey(unit.name(), TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.units." + unit.name(), new Object[0])));
        }
        SelectField units = new SelectField(PROPERTY_UNITS, TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.units", new Object[0]), values);
        units.setValue(Units.DEFAULT.name());
        fields.add(units);
        ArrayList<String> placeholderKeys = new ArrayList<String>();
        placeholderKeys.add("weather.city");
        placeholderKeys.add("weather.country");
        placeholderKeys.add("weather.description");
        placeholderKeys.add("weather.temperature");
        placeholderKeys.add("weather.pressure");
        placeholderKeys.add("weather.humidity");
        placeholderKeys.add("weather.windspeed");
        placeholderKeys.add("weather.sunrise");
        placeholderKeys.add("weather.sunset");
        ArrayList<TextField> conditionFields = new ArrayList<TextField>();
        TextField temperature = new TextField(PROPERTY_TEMPERATURE, TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.temperature", new Object[0]));
        conditionFields.add(temperature);
        ConditionInfo conditionInfo = new ConditionInfo(conditionFields);
        JobInfo info = new JobInfo(this.getExtensionName(), TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.name", new Object[0]), TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.description", new Object[0]), iconURL, null, conditionInfo, fields, placeholderKeys);
        return info;
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String apikey = definition.getProperty(PROPERTY_APIKEY);
        if (apikey == null || apikey.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.validation.apikey.empty", new Object[0])});
        }
        String location = definition.getProperty(PROPERTY_LOCATION);
        if (location == null || location.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.validation.location.empty", new Object[0])});
        }
    }

    protected void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
        ConditionDefinition condition = definition.getCondition();
        if (condition != null) {
            String temperature = condition.getProperty(PROPERTY_TEMPERATURE);
            try {
                Double.parseDouble(temperature);
            }
            catch (Throwable t) {
                throw new ValidationException(new String[]{TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.validation.temperature.invalid", new Object[0])});
            }
        }
    }

    protected OpenWeatherMapJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new OpenWeatherMapJob(definition.getProperty(PROPERTY_APIKEY), definition.getProperty(PROPERTY_LOCATION), definition.getProperty(PROPERTY_UNITS), definition.getCondition());
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> info = new ArrayList<SummaryEntry>();
        info.add(new SummaryEntry(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.location", new Object[0]), definition.getProperty(PROPERTY_LOCATION)));
        ArrayList<SummaryEntry> conditionInfo = null;
        ConditionDefinition condition = definition.getCondition();
        if (condition != null) {
            conditionInfo = new ArrayList<SummaryEntry>();
            String unitValue = definition.getProperty(PROPERTY_UNITS);
            Units units = Units.DEFAULT;
            if (unitValue != null) {
                try {
                    units = Units.valueOf(unitValue);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            conditionInfo.add(new SummaryEntry(TaskPlannerOpenWeatherMapServerPlugin.MSG.getMsg("taskplanner.openweathermap.temperature", new Object[0]), condition.getProperty(PROPERTY_TEMPERATURE) + " " + units.getTemperatureUnit()));
        }
        return new JobSummaryInfo(info, conditionInfo);
    }
}

