# TaskPlanner: Open Weather Map Plugin

This readme describes how to use the sample to create a custom Task Planner job. In this example the current weather information is requested from [http://openweathermap.org](http://openweathermap.org) and processed to be delivered to actions as text data and placeholders.

It includes a condition that checks whether the current temperature is above an entered value.

## Activate the included plugin

A compiled version of the plugin is made available as `taskplanner.openweathermap.zip`. In order to test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details. The OpenWeatherMap job is now available in the Task Planner job selection.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some modifications, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `taskplanner.jar` (included in `plugins/taskplanner.zip`) 

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `taskplanner.openweathermap.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `taskplanner.openweathermap.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configure the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

