/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.logaction;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.logging.LogLevel;
import com.inet.taskplanner.logaction.LogResultAction;
import com.inet.taskplanner.logaction.TaskPlannerLogActionServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LogResultActionFactory
extends ResultActionFactory<LogResultAction> {
    private static final String PROPERTY_LOG_NAME = "logname";
    private static final String PROPERTY_LOG_LEVEL = "loglevel";
    private static final String DEFAULT_LOG_NAME = "Task Planner";
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.STATUS;

    public LogResultActionFactory() {
        super("action.log");
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.TEXT);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = TaskPlannerLogActionServerPlugin.MSG.getMsg("taskplanner.logaction.name", new Object[0]);
        String description = TaskPlannerLogActionServerPlugin.MSG.getMsg("taskplanner.logaction.description", new Object[0]);
        URL icon = ((Object)((Object)this)).getClass().getResource("/com/inet/taskplanner/logaction/taskplanner_logaction_32.png");
        String helpkey = null;
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField logName = new TextField(PROPERTY_LOG_NAME, TaskPlannerLogActionServerPlugin.MSG.getMsg("taskplanner.logaction.logname", new Object[0]));
        logName.setPlaceholder(DEFAULT_LOG_NAME);
        fields.add(logName);
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey(LogLevel.STATUS.name(), LogLevel.STATUS.name()));
        values.add(new LocalizedKey(LogLevel.ERROR.name(), LogLevel.ERROR.name()));
        values.add(new LocalizedKey(LogLevel.WARN.name(), LogLevel.WARN.name()));
        values.add(new LocalizedKey(LogLevel.INFO.name(), LogLevel.INFO.name()));
        values.add(new LocalizedKey(LogLevel.DEBUG.name(), LogLevel.DEBUG.name()));
        SelectField logLevel = new SelectField(PROPERTY_LOG_LEVEL, TaskPlannerLogActionServerPlugin.MSG.getMsg("taskplanner.logaction.loglevel", new Object[0]), values);
        logLevel.setValue(DEFAULT_LOG_LEVEL.name());
        fields.add(logLevel);
        return new ResultActionInfo(this.getExtensionName(), name, description, icon, helpkey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
    }

    protected LogResultAction createInstanceFrom(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) {
        String logName = this.getResultingLogName(definition);
        LogLevel logLevel = this.getResultingLogLevel(definition);
        return new LogResultAction(logName, logLevel);
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> entries = new ArrayList<SummaryEntry>();
        String description = TaskPlannerLogActionServerPlugin.MSG.getMsg("taskplanner.logaction.summary", new Object[]{this.getResultingLogName(definition), this.getResultingLogLevel(definition).name()});
        entries.add(new SummaryEntry(null, description));
        return new SummaryInfo(entries);
    }

    private String getResultingLogName(ResultActionDefinition definition) {
        String logName = definition.getProperty(PROPERTY_LOG_NAME);
        if (logName == null || logName.trim().isEmpty()) {
            logName = DEFAULT_LOG_NAME;
        }
        return logName;
    }

    private LogLevel getResultingLogLevel(ResultActionDefinition definition) {
        LogLevel logLevel = DEFAULT_LOG_LEVEL;
        try {
            String logLevelName = definition.getProperty(PROPERTY_LOG_LEVEL);
            logLevel = LogLevel.valueOf((String)logLevelName);
        }
        catch (IllegalArgumentException iae) {
            TaskPlannerLogActionServerPlugin.LOGGER.error((Throwable)iae);
        }
        return logLevel;
    }
}

