/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.logaction;

import com.inet.logging.LogLevel;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.taskplanner.server.api.result.TextResult;
import java.io.IOException;
import java.util.List;

public class LogResultAction
extends ResultAction {
    private String logName;
    private LogLevel logLevel;

    public LogResultAction(String logName, LogLevel logLevel) {
        this.logName = logName;
        this.logLevel = logLevel;
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        Logger logger = LogManager.getLogger((String)this.logName);
        for (JobResultContainer resultContainer : results) {
            List textResults = resultContainer.getResults(ResultFlavor.TEXT);
            for (Result result : textResults) {
                TextResult textResult = (TextResult)result;
                try {
                    String text = textResult.getText();
                    if (text == null || text.isEmpty()) continue;
                    switch (this.logLevel) {
                        case DEBUG: {
                            logger.debug((Object)text);
                            break;
                        }
                        case ERROR: {
                            logger.error((Object)text);
                            break;
                        }
                        case INFO: {
                            logger.info((Object)text);
                            break;
                        }
                        case STATUS: {
                            logger.status((Object)text);
                            break;
                        }
                        case WARN: {
                            logger.warn((Object)text);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    throw new TaskExecutionException((Throwable)e);
                }
            }
        }
    }
}

