/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.om;

import com.ircclouds.irc.api.domain.WritableIRCUser;
import com.ircclouds.irc.api.domain.messages.AbstractPrivMsg;
import com.ircclouds.irc.api.domain.messages.ChannelActionMsg;
import com.ircclouds.irc.api.domain.messages.ChannelCTCPMsg;
import com.ircclouds.irc.api.domain.messages.ChannelPingMsg;
import com.ircclouds.irc.api.domain.messages.ChannelPrivMsg;
import com.ircclouds.irc.api.domain.messages.ChannelVersionMsg;
import com.ircclouds.irc.api.domain.messages.UserActionMsg;
import com.ircclouds.irc.api.domain.messages.UserCTCPMsg;
import com.ircclouds.irc.api.domain.messages.UserPing;
import com.ircclouds.irc.api.domain.messages.UserPrivMsg;
import com.ircclouds.irc.api.domain.messages.UserVersion;
import com.ircclouds.irc.api.om.IBuilder;
import com.ircclouds.irc.api.utils.ParseUtils;
import java.util.Set;

public abstract class AbstractPrivateMessageBuilder
implements IBuilder<AbstractPrivMsg> {
    private static final char NUL = '\u0001';
    private static final String EMPTY = " ";
    private static final String PING = "PING";
    private static final String VERSION = "VERSION";
    private static final String ACTION = "ACTION";

    @Override
    public AbstractPrivMsg build(String aMessage) {
        String[] _components = aMessage.split(EMPTY);
        WritableIRCUser _user = ParseUtils.getUser(_components[0]);
        AbstractPrivMsg _msg = null;
        String _m = aMessage.substring(aMessage.indexOf(58, 1) + 1);
        if (this.getChannelTypes().contains(Character.valueOf(_components[2].charAt(0)))) {
            ChannelPrivMsg _cPrivMsg = null;
            String _chanName = _components[2];
            if (_m.length() >= 2 && _m.charAt(0) == '\u0001' && _m.charAt(_m.length() - 1) == '\u0001') {
                String _type;
                _m = _type = _m.substring(1, _m.length() - 1);
                if (VERSION.equals(_type)) {
                    _cPrivMsg = new ChannelVersionMsg(_user, _m, _chanName);
                } else if (PING.equals(_type)) {
                    _cPrivMsg = new ChannelPingMsg(_user, _m, _chanName);
                } else if (_type.startsWith(ACTION)) {
                    _m = _m.substring(_m.indexOf(32) + 1);
                    _cPrivMsg = new ChannelActionMsg(_user, _m, _chanName);
                } else {
                    _cPrivMsg = new ChannelCTCPMsg(_user, _m, _chanName);
                }
            } else {
                _cPrivMsg = new ChannelPrivMsg(_user, _m, _chanName);
            }
            _msg = _cPrivMsg;
        } else if (_m.length() >= 2 && _m.charAt(0) == '\u0001' && _m.charAt(_m.length() - 1) == '\u0001') {
            String _type;
            _m = _type = _m.substring(1, _m.length() - 1);
            if (VERSION.compareTo(_type) <= 0) {
                _msg = new UserVersion(_user, _components[2], _m);
            } else if (PING.compareTo(_type) <= 0) {
                _msg = new UserPing(_user, _components[2], _m);
            } else if (_type.startsWith(ACTION)) {
                _m = _m.substring(_m.indexOf(32) + 1);
                _msg = new UserActionMsg(_user, _components[2], _m);
            } else {
                _msg = new UserCTCPMsg(_user, _components[2], _m);
            }
        } else {
            _msg = new UserPrivMsg(_user, _components[2], _m);
        }
        return _msg;
    }

    protected abstract Set<Character> getChannelTypes();
}

