/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.irc;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.taskplanner.irc.TaskPlannerIrcServerPlugin;
import com.inet.taskplanner.irc.a;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionHelper;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.PasswordField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@PublicApi
public class IrcResultActionFactory
extends ResultActionFactory<a> {
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_SSL = "ssl";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_NICKNAME = "nickname";
    public static final String PROPERTY_REALNAME = "realname";
    public static final String PROPERTY_CHANNEL = "channel";
    public static final String PROPERTY_STARTMESSAGE = "startmessage";
    public static final String PROPERTY_QUITMESSAGE = "quitmessage";
    public static final String PROPERTY_SENDRESULTS = "sendresults";

    public IrcResultActionFactory() {
        super("result.irc");
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE, ResultFlavor.TEXT);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/inet/taskplanner/irc/taskplanner.irc.png");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TextField textField = new TextField(PROPERTY_SERVER, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.server", new Object[0]));
        TextField textField2 = new TextField(PROPERTY_PORT, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.port", new Object[0]));
        textField2.setPlaceholder("6667");
        BooleanField booleanField = new BooleanField(PROPERTY_SSL, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.ssl", new Object[0]));
        PasswordField passwordField = new PasswordField(PROPERTY_PASSWORD, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.password", new Object[0]));
        TextField textField3 = new TextField(PROPERTY_NICKNAME, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.nickname", new Object[0]));
        textField3.setPlaceholder("taskbot");
        TextField textField4 = new TextField(PROPERTY_REALNAME, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.realname", new Object[0]));
        textField4.setPlaceholder("Task Planner IRC Bot");
        TextField textField5 = new TextField(PROPERTY_CHANNEL, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.channel", new Object[0]));
        textField5.setPlaceholder("#tasks");
        TextField textField6 = new TextField(PROPERTY_STARTMESSAGE, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.startmessage", new Object[0]));
        textField6.setPlaceholder(TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.startmessage.default", new Object[0]));
        TextField textField7 = new TextField(PROPERTY_QUITMESSAGE, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.quitmessage", new Object[0]));
        textField7.setPlaceholder(TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.quitmessage.default", new Object[0]));
        BooleanField booleanField2 = new BooleanField(PROPERTY_SENDRESULTS, TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.sendresults", new Object[0]), TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.sendresults.posttext", new Object[0]));
        arrayList.add(textField);
        arrayList.add(textField2);
        arrayList.add(booleanField);
        arrayList.add(passwordField);
        arrayList.add(textField3);
        arrayList.add(textField4);
        arrayList.add(textField5);
        arrayList.add(textField6);
        arrayList.add(textField7);
        arrayList.add(booleanField2);
        ResultActionInfo resultActionInfo = new ResultActionInfo(this.getExtensionName(), TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.name", new Object[0]), TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.description", new Object[0]), uRL, "taskplanner.action.irc", arrayList);
        return resultActionInfo;
    }

    protected void validate(ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String string;
        Map map = definition.getProperties();
        String string2 = ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_SERVER);
        if (string2.trim().isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.error.serverempty", new Object[0])});
        }
        String string3 = ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_PORT, (String)"6667");
        if (!this.hasPlaceholderSet(string3, taskID)) {
            try {
                int n = Integer.parseInt(string3);
                if (n < 1 || n > 65535) {
                    throw new ValidationException(new String[]{TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.error.portrange", new Object[0])});
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidationException(new String[]{TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.error.portinvalid", new Object[0])});
            }
        }
        if (!this.hasPlaceholderSet(string = ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_CHANNEL, (String)"#tasks"), taskID) && !string.startsWith("#")) {
            throw new ValidationException(new String[]{TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.error.channelinvalid", new Object[0])});
        }
    }

    protected a createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        return new a(definition);
    }

    public SummaryInfo getSummary(ResultActionDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        Map map = definition.getProperties();
        arrayList.add(new SummaryEntry(TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.server", new Object[0]), ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_SERVER)));
        arrayList.add(new SummaryEntry(TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.nickname", new Object[0]), ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_NICKNAME, (String)"taskbot")));
        arrayList.add(new SummaryEntry(TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.channel", new Object[0]), ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_CHANNEL, (String)"#tasks")));
        arrayList.add(new SummaryEntry(TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.startmessage", new Object[0]), ResultActionHelper.getNonEmptyProperty((Map)map, (String)PROPERTY_STARTMESSAGE, (String)TaskPlannerIrcServerPlugin.MSG.getMsg("taskplanner.irc.resulthandler.startmessage.default", new Object[0]))));
        return new SummaryInfo(arrayList);
    }
}

