/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.setupwizard;

import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.shared.utils.Version;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessTriggerAndSeriesMigrationToIdSetupStep
extends AutoSetupStep {
    public static final StepKey KEY = new StepKey("TaskPlannerProcessToIdMigrationSetupStep");

    public StepKey stepKey() {
        return KEY;
    }

    public String getStepDisplayName() {
        return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TaskPlanner.migratingProcessesToIds", new Object[0]);
    }

    public boolean hasPendingTasks() {
        Version lastMigratedVersionOfTicketProcess = ProcessTriggerAndSeriesMigrationToIdSetupStep.getLastMigratedVersionOf((String)"ticketprocess");
        return lastMigratedVersionOfTicketProcess != null && !lastMigratedVersionOfTicketProcess.isHigherOrEquals(new Version("23.4"));
    }

    protected void waitForVeto() {
        UserManagerWait.waitForUserManagerVeto((StepExecutionProgressListener)this.getStepExecutionProgressListener(), (SetupStep)this);
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        this.waitForVeto();
        TaskPlanner tp = this.getTaskPlanner();
        List allTaskIDs = tp.getAllTaskIDs();
        TicketProcessManager ticketProcessManager = this.getTicketProcessManager();
        List processes = ticketProcessManager.getProcesses();
        HashMap nameToId = new HashMap();
        processes.forEach(p -> nameToId.put(p.getName(), p.getId()));
        allTaskIDs.forEach(g -> {
            String property;
            TaskDefinition d = tp.getTaskDefinition(g);
            if (d == null) {
                return;
            }
            List triggers = d.getTriggers();
            triggers.forEach(t -> {
                String property = t.getProperty("processFilter");
                if (property != null) {
                    GUID guid = (GUID)nameToId.get(property);
                    t.setProperty("processFilter", guid == null ? "" : guid.toString());
                }
            });
            SeriesDefinition series = d.getSeries();
            if (series != null && (property = series.getProperty("processFilter")) != null) {
                GUID guid = (GUID)nameToId.get(property);
                series.setProperty("processFilter", guid == null ? "" : guid.toString());
            }
            tp.updateTask(g, d);
        });
    }

    protected TicketProcessManager getTicketProcessManager() {
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }

    protected TaskPlanner getTaskPlanner() {
        return TaskPlanner.getInstance();
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(7683);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TaskPlanner.migratingProcessesToIds.executionMessage", new Object[0]);
    }
}

