/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.setupwizard;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.setupwizard.api.AutoSetupStep;
import com.inet.setupwizard.api.EmptyStepConfig;
import com.inet.setupwizard.api.InfoMessageGetter;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.api.SetupStepPriority;
import com.inet.setupwizard.api.StepExecutionException;
import com.inet.setupwizard.api.StepExecutionProgressListener;
import com.inet.setupwizard.api.StepKey;
import com.inet.setupwizard.basicsteps.UserManagerWait;
import com.inet.shared.utils.Version;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomFieldConditionsMigrationSetupStep
extends AutoSetupStep {
    private static final String PROPERTY_FILTER_TYPE_ITIL = "FilterTypeITIL";
    private static final String PROPERTY_FILTER_TYPE_RESOURCE = "FilterTypeResource";
    private static final String PROPERTY_FILTER_TYPE_CLASSIFICATION = "FilterTypeClassification";
    private static final String PROPERTY_FILTER_TYPE_DEADLINE = "FilterTypeDeadline";
    private static final String PROPERTY_FILTER_TYPE_IDENTIFIER = "FilterTypeIdentifier";
    private static final String PROPERTY_FILTER_TYPE_SUBJECT = "FilterTypeSubject";
    private static final String PROPERTY_FILTER_TYPE_PRIORITY = "FilterTypePriority";
    private static final String PROPERTY_FILTER_TYPE_OWNER = "FilterTypeOwner";
    StepKey KEY = new StepKey("CustomFieldConditionsMigrationSetupStep");

    public StepKey stepKey() {
        return this.KEY;
    }

    public String getStepDisplayName() {
        return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TaskPlanner.migrationCustomFieldConditions", new Object[0]);
    }

    public boolean hasPendingTasks() {
        return true;
    }

    protected void waitForVeto() {
        UserManagerWait.waitForUserManagerVeto((StepExecutionProgressListener)this.getStepExecutionProgressListener(), (SetupStep)this);
    }

    public void execute(EmptyStepConfig stepConfig, Map<String, String> metaData) throws StepExecutionException {
        this.waitForVeto();
        TaskPlanner tp = this.getTaskPlannerInstance();
        List allTaskIDs = tp.getAllTaskIDs();
        allTaskIDs.forEach(g -> {
            TaskDefinition d = tp.getTaskDefinition(g);
            if (d == null) {
                return;
            }
            d.getTriggers().forEach(t -> this.replaceOldWithNew((AbstractDefinition)t));
            d.getJobs().forEach(j -> this.replaceOldWithNew((AbstractDefinition)j));
            d.getResultActions().forEach(j -> {
                String property = j.getProperty("fieldToChange");
                if (!j.getExtensionName().equalsIgnoreCase("result.setticketfield") || property == null) {
                    return;
                }
                TicketFieldDefinition tfd = null;
                List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                for (TicketFieldDefinition tDef : fieldDefs) {
                    if (!tDef.getKey().equals(property)) continue;
                    tfd = tDef;
                }
                switch (property) {
                    case "FilterTypeCategory": 
                    case "FilterTypeResource": {
                        break;
                    }
                    case "FilterTypeClassification": {
                        if (j.getProperty("selectValueToSet." + Tickets.FIELD_CLASSIFICATION_ID.getKey() + ".display") != null) break;
                        String classId = j.getProperty("Classification");
                        j.setProperty("fieldToChange", Tickets.FIELD_CLASSIFICATION_ID.getKey());
                        j.setProperty("selectValueToSet." + Tickets.FIELD_CLASSIFICATION_ID.getKey(), classId);
                        try {
                            Integer o = (Integer)Tickets.FIELD_CLASSIFICATION_ID.getFieldType().valueOf(classId);
                            if (o != null) {
                                j.setProperty("selectValueToSet." + Tickets.FIELD_CLASSIFICATION_ID.getKey() + ".display", Tickets.FIELD_CLASSIFICATION_ID.valueToString(o));
                                break;
                            }
                            j.setProperty("selectValueToSet." + Tickets.FIELD_CLASSIFICATION_ID.getKey() + ".display", "");
                        }
                        catch (NumberFormatException e) {
                            HDLogger.warn((Object)e);
                            j.setProperty("selectValueToSet." + Tickets.FIELD_CLASSIFICATION_ID.getKey() + ".display", "");
                        }
                        break;
                    }
                    case "FilterTypeITIL": {
                        if (j.getProperty("selectValueToSet." + Tickets.FIELD_ITIL_ID.getKey() + ".display") != null) break;
                        String itilId = j.getProperty("ITIL");
                        j.setProperty("fieldToChange", Tickets.FIELD_ITIL_ID.getKey());
                        j.setProperty("selectValueToSet." + Tickets.FIELD_ITIL_ID.getKey(), itilId);
                        try {
                            Integer i = (Integer)Tickets.FIELD_ITIL_ID.getFieldType().valueOf(itilId);
                            if (i != null) {
                                j.setProperty("selectValueToSet." + Tickets.FIELD_ITIL_ID.getKey() + ".display", Tickets.FIELD_ITIL_ID.valueToString(i));
                                break;
                            }
                            j.setProperty("selectValueToSet." + Tickets.FIELD_ITIL_ID.getKey() + ".display", "");
                        }
                        catch (NumberFormatException e) {
                            HDLogger.warn((Object)e);
                            j.setProperty("selectValueToSet." + Tickets.FIELD_ITIL_ID.getKey() + ".display", "");
                        }
                        break;
                    }
                    case "FilterTypePriority": {
                        if (j.getProperty("selectValueToSet." + Tickets.FIELD_PRIORITY_ID.getKey() + ".display") != null) break;
                        String priorityId = j.getProperty("Priority");
                        j.setProperty("fieldToChange", Tickets.FIELD_PRIORITY_ID.getKey());
                        j.setProperty("selectValueToSet." + Tickets.FIELD_PRIORITY_ID.getKey(), priorityId);
                        try {
                            Integer p = (Integer)Tickets.FIELD_PRIORITY_ID.getFieldType().valueOf(priorityId);
                            if (p != null) {
                                j.setProperty("selectValueToSet." + Tickets.FIELD_PRIORITY_ID.getKey() + ".display", Tickets.FIELD_PRIORITY_ID.valueToString(p));
                                break;
                            }
                            j.setProperty("selectValueToSet." + Tickets.FIELD_PRIORITY_ID.getKey() + ".display", "");
                        }
                        catch (NumberFormatException e) {
                            HDLogger.warn((Object)e);
                            j.setProperty("selectValueToSet." + Tickets.FIELD_PRIORITY_ID.getKey() + ".display", "");
                        }
                        break;
                    }
                    case "targettime": {
                        String targetTimeValue = j.getProperty("valueToSet");
                        if (targetTimeValue == null) break;
                        j.setProperty("textFieldValueToSet", targetTimeValue);
                        break;
                    }
                    default: {
                        String valueString = j.getProperty("valueToSet");
                        if (tfd == null || tfd.getEditDefinition() == null || tfd.getEditDefinition().getDisplayType().equals("datevalue") || tfd.getEditDefinition().getDisplayType().equals("select")) break;
                        String valueToSetProp = this.extractFromType(tfd);
                        if (valueToSetProp != null && j.getProperty(valueToSetProp) == null) {
                            j.setProperty(valueToSetProp, valueString);
                        }
                        if (!property.equals("custom5") || j.getProperty("textAreaValueToSet") == null) break;
                        j.setProperty("textFieldValueToSet", j.getProperty("textAreaValueToSet"));
                    }
                }
            });
            SeriesDefinition series = d.getSeries();
            if (series != null) {
                this.replaceOldWithNew((AbstractDefinition)series);
            }
            tp.updateTask(g, d);
        });
    }

    private String extractFromType(TicketFieldDefinition editDef) {
        FieldEditDefinition editDefinition = editDef.getEditDefinition();
        if (editDefinition == null) {
            return null;
        }
        switch (editDefinition.getDisplayType()) {
            case "timeonlyvalue": {
                return "timeValueToSet";
            }
            case "textinput": {
                return "textFieldValueToSet";
            }
            case "textarea": {
                return "textAreaValueToSet";
            }
            case "boolean": {
                return "booleanValueToSet";
            }
            case "integer": {
                return "numberValueToSet";
            }
            case "double": {
                return "floatValueToSet";
            }
            case "currency": {
                return "currValueToSet";
            }
        }
        return null;
    }

    protected TaskPlanner getTaskPlannerInstance() {
        return TaskPlanner.getInstance();
    }

    private void replaceOldWithNew(AbstractDefinition t) {
        String classificationFromOldProperty;
        String filterType = t.getProperty("FilterType");
        this.replaceFirstType(t, filterType);
        String secondFilterType = t.getProperty("Second.FilterType");
        this.replaceSecondType(t, secondFilterType);
        if ("taskplanner.helpdesk.change-classification".equals(t.getExtensionName()) && (classificationFromOldProperty = t.getProperty("Classification")) != null) {
            t.setProperty(Tickets.FIELD_CLASSIFICATION_ID.getKey(), classificationFromOldProperty);
            t.setProperty(Tickets.FIELD_CLASSIFICATION_ID.getKey() + ".display", t.getProperty("Classification.display"));
            t.setProperty(Tickets.FIELD_CLASSIFICATION_ID.getKey() + ".icon", t.getProperty("Classification.icon"));
        }
    }

    private void replaceFirstType(AbstractDefinition t, String filterType) {
        block8: {
            if (filterType != null && this.needsNameChanging(filterType)) {
                String newName = this.getNewNameForOldFilterType(filterType);
                String oldPropertyName = this.getOldPropertyNameForOldFilterType(filterType);
                if (oldPropertyName == null) {
                    HDLogger.error((Object)("unknown filter type " + filterType + " in " + String.valueOf(t.getUid())));
                    return;
                }
                if (t.getProperty("fflg." + newName + ".display") != null) {
                    return;
                }
                t.setProperty("FilterType", newName);
                String property = t.getProperty(oldPropertyName);
                t.setProperty("fflg." + newName, property);
                TicketField ticketField = Tickets.getFieldByKey((String)newName);
                if (ticketField != null) {
                    try {
                        Object o = ticketField.getFieldType().valueOf(property);
                        if (o != null) {
                            t.setProperty("fflg." + newName + ".display", ticketField.valueToString(o));
                            break block8;
                        }
                        t.setProperty("fflg." + newName + ".display", "");
                    }
                    catch (NumberFormatException e) {
                        HDLogger.warn((Object)e);
                        t.setProperty("fflg." + newName + ".display", "");
                    }
                } else {
                    t.setProperty("fflg." + newName + ".display", "");
                }
            }
        }
    }

    private void replaceSecondType(AbstractDefinition t, String secondFilterType) {
        block9: {
            if (secondFilterType != null && this.needsNameChanging(secondFilterType)) {
                String newName = this.getNewNameForOldFilterType(secondFilterType);
                String oldPropertyName = this.getOldPropertyNameForOldFilterType(secondFilterType);
                if (oldPropertyName == null) {
                    HDLogger.error((Object)("unknown second filter type " + secondFilterType + " in " + String.valueOf(t.getUid())));
                    return;
                }
                if (t.getProperty("fflg.Second." + newName + ".display") != null) {
                    return;
                }
                t.setProperty("Second.FilterType", newName);
                String property = t.getProperty("Second." + oldPropertyName);
                if (oldPropertyName.startsWith("fflg.")) {
                    property = t.getProperty("fflg.Second." + oldPropertyName.substring(5));
                }
                t.setProperty("fflg.Second." + newName, property);
                TicketField ticketField = Tickets.getFieldByKey((String)newName);
                if (ticketField != null) {
                    try {
                        Object o = ticketField.getFieldType().valueOf(property);
                        if (o != null) {
                            t.setProperty("fflg.Second." + newName + ".display", ticketField.valueToString(o));
                            break block9;
                        }
                        t.setProperty("fflg.Second." + newName + ".display", "");
                    }
                    catch (NumberFormatException e) {
                        HDLogger.warn((Object)e);
                        t.setProperty("fflg.Second." + newName + ".display", "");
                    }
                } else {
                    t.setProperty("fflg.Second." + newName + ".display", "");
                }
            }
        }
    }

    private boolean needsNameChanging(@Nonnull String filterType) {
        HashSet<String> specialCasesWhichStayTheSame = new HashSet<String>();
        specialCasesWhichStayTheSame.add(PROPERTY_FILTER_TYPE_RESOURCE);
        specialCasesWhichStayTheSame.add("FilterTypeCustomerLocation");
        specialCasesWhichStayTheSame.add("FilterTypeCategory");
        specialCasesWhichStayTheSame.add("FilterTypeInquiryText");
        specialCasesWhichStayTheSame.add("FilterTypeOwnerField");
        specialCasesWhichStayTheSame.add("FilterTypeProcessFilter");
        specialCasesWhichStayTheSame.add(Tickets.FIELD_ADDITIONAL_ACCESS.getKey());
        return !specialCasesWhichStayTheSame.contains(filterType);
    }

    private String getNewNameForOldFilterType(@Nonnull String oldFilterType) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("FilterTypeCustom1", "custom1");
        nameMap.put("FilterTypeCustom2", "custom2");
        nameMap.put("FilterTypeCustom3", "custom3");
        nameMap.put("FilterTypeCustom4", "custom4");
        nameMap.put("FilterTypeCustom5", "custom5");
        nameMap.put("FilterTypeCustom6", "custom6");
        nameMap.put("FilterTypeCustom7", "custom7");
        nameMap.put(PROPERTY_FILTER_TYPE_ITIL, Tickets.FIELD_ITIL_ID.getKey());
        nameMap.put(PROPERTY_FILTER_TYPE_CLASSIFICATION, Tickets.FIELD_CLASSIFICATION_ID.getKey());
        nameMap.put(PROPERTY_FILTER_TYPE_DEADLINE, Tickets.FIELD_DEADLINE.getKey());
        nameMap.put(PROPERTY_FILTER_TYPE_IDENTIFIER, Tickets.FIELD_IDENTIFIER.getKey());
        nameMap.put(PROPERTY_FILTER_TYPE_SUBJECT, Tickets.FIELD_SUBJECT.getKey());
        nameMap.put(PROPERTY_FILTER_TYPE_PRIORITY, Tickets.FIELD_PRIORITY_ID.getKey());
        nameMap.put(PROPERTY_FILTER_TYPE_OWNER, Tickets.FIELD_OWNER_GUID.getKey());
        String result = (String)nameMap.get(oldFilterType);
        if (result == null) {
            return oldFilterType;
        }
        return result;
    }

    private String getOldPropertyNameForOldFilterType(@Nonnull String oldFilterType) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("FilterTypeCustom1", "Custom1");
        nameMap.put("FilterTypeCustom2", "Custom2");
        nameMap.put("FilterTypeCustom3", "Custom3");
        nameMap.put("FilterTypeCustom4", "Custom4");
        nameMap.put("FilterTypeCustom5", "Custom5");
        nameMap.put("FilterTypeCustom6", "Custom6");
        nameMap.put("FilterTypeCustom7", "Custom7");
        nameMap.put("custom1", "fflg.custom1");
        nameMap.put("custom2", "fflg.custom2");
        nameMap.put("custom3", "fflg.custom3");
        nameMap.put("custom4", "fflg.custom4");
        nameMap.put("custom5", "fflg.custom5");
        nameMap.put("custom6", "fflg.custom6");
        nameMap.put("custom7", "fflg.custom7");
        String PROPERTY_ITIL = "ITIL";
        nameMap.put(PROPERTY_FILTER_TYPE_ITIL, PROPERTY_ITIL);
        String PROPERTY_PRIORITY = "Priority";
        nameMap.put(PROPERTY_FILTER_TYPE_PRIORITY, PROPERTY_PRIORITY);
        String PROPERTY_CLASSIFICATION = "Classification";
        nameMap.put(PROPERTY_FILTER_TYPE_CLASSIFICATION, PROPERTY_CLASSIFICATION);
        String PROPERTY_DEADLINE = "Deadline";
        nameMap.put(PROPERTY_FILTER_TYPE_DEADLINE, PROPERTY_DEADLINE);
        String PROPERTY_IDENTIFIER = "Identifier";
        nameMap.put(PROPERTY_FILTER_TYPE_IDENTIFIER, PROPERTY_IDENTIFIER);
        String PROPERTY_SUBJECT = "Subject";
        nameMap.put(PROPERTY_FILTER_TYPE_SUBJECT, PROPERTY_SUBJECT);
        String PROPERTY_OWNER = "Owner";
        nameMap.put(PROPERTY_FILTER_TYPE_OWNER, PROPERTY_OWNER);
        String result = (String)nameMap.get(oldFilterType);
        if (result == null) {
            return "fflg." + oldFilterType;
        }
        return result;
    }

    public SetupStepPriority getPriority() {
        return new SetupStepPriority(7697);
    }

    public InfoMessageGetter getExecutionInfoMessage(EmptyStepConfig stepConfig) {
        return () -> HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TaskPlanner.migrationCustomFieldConditions.executionMessage", new Object[0]);
    }

    @Nullable
    public Version getMigrationVersion() {
        return new Version("25.4.38");
    }
}

