/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.newticket;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TicketFilterChecker;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NewTicketTrigger
implements Trigger,
TicketEventListener {
    private final String dispatchedFilterType;
    private Trigger.TriggerAction triggerAction;
    public Set<Integer> ticketIdsWhichAlreadyTriggeredThisTrigger = new HashSet<Integer>();
    private final TicketFilterChecker filterChecker;
    private GUID taskID;

    public NewTicketTrigger(TriggerDefinition definition, GUID taskID) {
        this.filterChecker = new TicketFilterChecker(definition.getProperties());
        this.dispatchedFilterType = definition.getProperties().getOrDefault("dispatchedFilterKey", "dispatchedFilter.any");
        this.taskID = taskID;
    }

    public void activate(GUID guid, Trigger.TriggerAction triggerAction) {
        this.triggerAction = triggerAction;
        this.registerListener();
    }

    protected void registerListener() {
        HDTaskPlannerDataListener.addListener(this);
    }

    public void deactivate() {
        this.triggerAction = null;
        this.unregisterListener();
    }

    protected void unregisterListener() {
        HDTaskPlannerDataListener.removeListener(this);
    }

    public void ticketsAdded(List<Integer> unfilteredlist) {
        List filteredList;
        TaskExecution execution = TaskPlanner.getInstance().getTaskExecution(this.taskID);
        final GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
        try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
            filteredList = unfilteredlist.stream().filter(this::isInFilter).collect(Collectors.toList());
        }
        final Trigger.TriggerAction a = this.triggerAction;
        if (a != null && filteredList.size() > 0) {
            DefaultTimer t = DefaultTimer.getInstance();
            HDLogger.debug((Object)("NewTicketTrigger: plan trigger for " + filteredList.size() + " tickets."));
            t.schedule(new DefaultTimerTask(){

                public void runImpl() throws Throwable {
                    List list = filteredList.stream().filter(t -> !NewTicketTrigger.this.ticketIdsWhichAlreadyTriggeredThisTrigger.contains(t) && !HDTaskPlannerDataListener.getRegisteredInstance().wasTicketCreatedByThisTask((int)t, NewTicketTrigger.this.taskID)).collect(Collectors.toList());
                    try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                        HDLogger.debug((Object)("NewTicketTrigger: trigger now for tickets: " + list.toString()));
                        if (list.size() > 0) {
                            NewTicketTrigger.this.ticketIdsWhichAlreadyTriggeredThisTrigger.addAll(list);
                            for (Integer ticketId : list) {
                                try {
                                    TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                                    if (ticket == null) continue;
                                    Map<String, String> props = NewTicketTrigger.this.getPropsFor(ticket);
                                    String ticketIDProp = props.get("Ticket ID");
                                    if (ticketIDProp != null) {
                                        props.put("Ticket ID", ticketIDProp.trim());
                                    }
                                    a.execute(props);
                                }
                                catch (AccessDeniedException exc) {}
                            }
                        }
                    }
                }
            }, new Date(System.currentTimeMillis() + this.getDelay()));
        }
    }

    protected Map<String, String> getPropsFor(TicketVO ticket) {
        Map<String, String> props = HDPlaceholderUtils.fillPlaceholderValuesFor(ticket);
        ActionVO action = (ActionVO)ActionManager.getInstance().get(4);
        int initialReaStepID = ticket.getInitialReaStepID();
        ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(initialReaStepID);
        ReaStepVO reaStepData = TicketManager.getReader().getReaStep(initialReaStepID);
        props.putAll(HDPlaceholders.fillActionPlaceholderValuesFor(action, reaStepData, reaStepText));
        return props;
    }

    protected long getDelay() {
        return 3000L;
    }

    private boolean isInFilter(Integer ticketId) {
        if (HDTaskPlannerDataListener.getRegisteredInstance().wasTicketCreatedByThisTask(ticketId, this.taskID)) {
            return false;
        }
        UserAccount user = UserManager.getInstance().getCurrentUserAccount();
        if (user == null) {
            HDLogger.warn((Object)"TriggerTicketDataChangeListener: no current user - no ticket list");
            return false;
        }
        Set<Integer> alreadyTriggeredIds = this.ticketIdsWhichAlreadyTriggeredThisTrigger;
        if (alreadyTriggeredIds.contains(ticketId)) {
            return false;
        }
        try {
            TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
            return this.filterChecker.check(this.getServerValuesConnector(), ticket, user);
        }
        catch (AccessDeniedException exc) {
            return false;
        }
    }

    protected ServerValuesConnector getServerValuesConnector() {
        return (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
    }

    public void handleEvent(TicketEvent ticketEvent) {
        if (this.triggerAction == null) {
            return;
        }
        List changedTickets = ticketEvent.getChangedTickets();
        Set ticketsAdded = changedTickets.stream().filter(vo -> {
            boolean isNewTicket;
            boolean bl = isNewTicket = vo.getOldTicket() == null && vo.getNewTicket() != null;
            if (!isNewTicket) {
                boolean wasTicketDeleted;
                boolean bl2 = wasTicketDeleted = vo.getOldTicket() != null && vo.getNewTicket() == null;
                if (wasTicketDeleted) {
                    this.ticketIdsWhichAlreadyTriggeredThisTrigger.remove(vo.getOldTicket().getID());
                }
                return false;
            }
            if ("dispatchedFilter.any".equals(this.dispatchedFilterType)) {
                return true;
            }
            Integer dispatchingReaId = vo.getNewTicket().getDispatchingReaStepID();
            if (dispatchingReaId != null) {
                return "dispatchedFilter.onlydispatch".equals(this.dispatchedFilterType);
            }
            return "dispatchedFilter.onlyinquiries".equals(this.dispatchedFilterType);
        }).map(ChangedTicketVO::getTicketID).collect(Collectors.toSet());
        if (ticketsAdded.size() > 0) {
            this.ticketsAdded(new ArrayList<Integer>(ticketsAdded));
        }
    }
}

