/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.addattachment;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.utils.StringConcatenator;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.plugins.taskplanner.server.job.addattachment.AddAttachmentToTicketJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeries;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class AddAttachmentToTicketJob
extends Job {
    static final String PROPERTY_ATTACHMENT_FILE_PATH = "AttachmentFilePath";
    private final List<Integer> ticketIds;
    private final String attachmentFilePath;
    private GUID taskID;

    public AddAttachmentToTicketJob(JobDefinition definition, @Nullable GUID taskID) {
        super(definition.getCondition());
        this.taskID = taskID;
        Map properties = definition.getProperties();
        String ticketIdString = properties.getOrDefault("Ticket ID", "-1");
        if (ticketIdString != null && ticketIdString.contains("Ticket ID")) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        this.ticketIds = ticketIdString == null ? new ArrayList() : HDPlaceholderUtils.getTicketIds(ticketIdString);
        this.attachmentFilePath = (String)properties.get(PROPERTY_ATTACHMENT_FILE_PATH);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Reading local files is limited to admin-users")
    protected JobResultContainer run() throws TaskExecutionException {
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        for (Integer ticketId : this.ticketIds) {
            try {
                ArrayList<String> resultingFileNamesOfAddedAttachments;
                block24: {
                    TicketVO ticket;
                    HashSet<Integer> changedIds = (HashSet<Integer>)TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.get();
                    if (changedIds == null) {
                        changedIds = new HashSet<Integer>();
                    }
                    changedIds.add(ticketId);
                    TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.set(changedIds);
                    try {
                        ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                    }
                    catch (AccessDeniedException e) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)e));
                        continue;
                    }
                    if (ticket == null) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicket", new Object[]{ticketId}))));
                        continue;
                    }
                    if (ticket.getStatusID() >= 300) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketNotOpenError", new Object[]{ticketId}))));
                        continue;
                    }
                    if (this.attachmentFilePath == null) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NoAttachmentPath", new Object[0]))));
                        continue;
                    }
                    if (AddAttachmentToTicketJobFactory.isRestrictedPath(this.attachmentFilePath)) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NoConfigurationPermission", new Object[0]))));
                        continue;
                    }
                    resultingFileNamesOfAddedAttachments = new ArrayList<String>();
                    TicketAttachmentProvider attachmentsProvider = this.getTicketAttachmentProvider();
                    if (ticket.isSlaveInBundle()) continue;
                    File attFile = new File(this.attachmentFilePath);
                    if (!attFile.exists()) {
                        try {
                            URL url = new URL(this.attachmentFilePath);
                            resultingFileNamesOfAddedAttachments.add(this.addURLAsAttachment(url, attachmentsProvider, ticketId));
                            break block24;
                        }
                        catch (MalformedURLException e) {
                            toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FileNotExists", new Object[]{this.attachmentFilePath}))));
                            continue;
                        }
                    }
                    if (attFile.isDirectory()) {
                        File[] files;
                        for (File file : files = attFile.listFiles()) {
                            if (!file.isFile()) continue;
                            resultingFileNamesOfAddedAttachments.add(this.addFileAsAttachment(file, attachmentsProvider, ticketId));
                        }
                    } else if (attFile.isFile()) {
                        resultingFileNamesOfAddedAttachments.add(this.addFileAsAttachment(attFile, attachmentsProvider, ticketId));
                    }
                }
                if (resultingFileNamesOfAddedAttachments.isEmpty()) continue;
                String allAttFileNames = String.join((CharSequence)", ", resultingFileNamesOfAddedAttachments);
                String prefix = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddedByTaskPlanner", new Object[0]) + " ";
                String stepDesc = prefix + allAttFileNames;
                ReaStepTextVO stepText = ReaStepTextVO.empty();
                int maxAttFileNamesLength = 255 - prefix.length();
                if (allAttFileNames.length() > maxAttFileNamesLength) {
                    stepDesc = prefix + StringConcatenator.concatAndShortenIfNeeded(resultingFileNamesOfAddedAttachments, (int)maxAttFileNamesLength);
                    stepText = ReaStepTextVO.of((String)(prefix + allAttFileNames), (boolean)false);
                }
                WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
                try {
                    MutableReaStepData stepData = new MutableReaStepData();
                    stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)stepDesc);
                    ActionVO action = (ActionVO)this.getActionManager().get(-21);
                    this.getTicketManipulator().applyAction(ticketId.intValue(), stepData, stepText, action, null);
                }
                finally {
                    if (addReaStepData == null) continue;
                    addReaStepData.close();
                }
            }
            catch (Exception e) {
                toThrow.add((Exception)new TaskExecutionException((Throwable)e));
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        return null;
    }

    private String addFileAsAttachment(File attFile, TicketAttachmentProvider attachmentsProvider, int ticketId) throws IOException {
        AttachmentDescription desc = new AttachmentDescription();
        desc.setFileName(attFile.getName());
        desc.setLastModified(System.currentTimeMillis());
        desc.setOwnerId(Integer.valueOf(ticketId));
        FileInputStream in = new FileInputStream(attFile);
        AttachmentDescription addedFile = attachmentsProvider.addFile(desc, (InputStream)in, AttachmentType.Attachment);
        return addedFile.getFileName();
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Adding files to an attachment is only allowed by admin users.")
    private String addURLAsAttachment(URL attURL, TicketAttachmentProvider attachmentsProvider, int ticketId) throws IOException {
        AttachmentDescription desc = new AttachmentDescription();
        String path = attURL.getPath();
        desc.setFileName(path.substring(path.lastIndexOf(47) + 1));
        desc.setLastModified(System.currentTimeMillis());
        desc.setOwnerId(Integer.valueOf(ticketId));
        InputStream in = attURL.openConnection().getInputStream();
        AttachmentDescription addedFile = attachmentsProvider.addFile(desc, in, AttachmentType.Attachment);
        return addedFile.getFileName();
    }

    protected TicketAttachmentProvider getTicketAttachmentProvider() {
        return (TicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class);
    }

    protected TicketManipulator getTicketManipulator() {
        return TicketManager.getManipulator();
    }

    protected ActionManager getActionManager() {
        return ActionManager.getInstance();
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        return false;
    }
}

