/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action;

import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.action.ApplyActionToTicketAction;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.BooleanField;
import com.inet.taskplanner.server.api.field.DisableCondition;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FilenameField;
import com.inet.taskplanner.server.api.field.HtmlTextAreaField;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.field.SelectInputField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplyActionToTicketActionFactory
extends ResultActionFactory<ApplyActionToTicketAction> {
    public static final String EXTENSION_NAME = "result.applyactiontoticket";
    public static final String PROPERTY_ACTION_TO_APPLY = "PROPERTY_ACTION_TO_APPLY";
    private static final int SELECT_TYPE_ACTION = 121315;
    private FilterFieldValues fieldValues;
    public static final String PROP_SUBJECT = "prop_subject";
    public static final String PROP_MESSAGE = "prop_message";
    public static final String PROP_RECEIVER = "prop_receiver";
    public static final String PROP_ATTACH_FILES = "prop_attach_files";
    public static final String PROPERTY_FILENAME_FORMAT = "filenameformat";
    static final String JOB_RESULT = "jobresult";
    public static final String DATE_VALUE_TO_SET = "dateValueToSet";
    public static final String WORKING_HOURS = "workingHours";
    public static final String TIME_SPENT = "timeSpent";

    public ApplyActionToTicketActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction(taskID, textField);
        fields.add(textField);
        SelectInputField actionFilter = new SelectInputField(PROPERTY_ACTION_TO_APPLY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.ActionToApply", new Object[0]), 121315);
        actionFilter.setValue("");
        fields.add(actionFilter);
        ArrayList<FieldCondition> conds = new ArrayList<FieldCondition>();
        for (ActionVO action : ActionManager.getInstance().getAll(true)) {
            if (action.getId() != -7 && action.getStatusID() != 211) continue;
            conds.add(FieldCondition.visible((Field)actionFilter, (FieldCondition.OP)FieldCondition.OP.equals, (String)("" + action.getId())));
        }
        TextField receiver = new TextField(PROP_RECEIVER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.email.recipient", new Object[0]));
        receiver.setConditions(conds);
        fields.add(receiver);
        TextField subject = new TextField(PROP_SUBJECT, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.email.subject", new Object[0]));
        subject.setConditions(conds);
        fields.add(subject);
        HtmlTextAreaField msg = new HtmlTextAreaField(PROP_MESSAGE, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.ReaText", new Object[0]));
        ArrayList<FieldCondition> msgConditions = new ArrayList<FieldCondition>();
        for (ActionVO action : ActionManager.getInstance().getAll(true)) {
            if (action.getId() == 947474 || action.getId() == 947475) continue;
            msgConditions.add(FieldCondition.visible((Field)actionFilter, (FieldCondition.OP)FieldCondition.OP.equals, (String)("" + action.getId())));
        }
        msg.setConditions(msgConditions);
        fields.add(msg);
        BooleanField attachFiles = new BooleanField(PROP_ATTACH_FILES, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.email.attach_files", new Object[0]));
        attachFiles.setConditions(conds);
        fields.add(attachFiles);
        FilenameField filenameFormat = new FilenameField(PROPERTY_FILENAME_FORMAT, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.email.filenameformat", new Object[0]));
        filenameFormat.setValue("[filename]");
        ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>(conds);
        conditions.add(DisableCondition.disabled((Field)attachFiles, (FieldCondition.OP)FieldCondition.OP.notequal, (String)"true"));
        filenameFormat.setConditions(conditions);
        fields.add(filenameFormat);
        ArrayList<UnitConfigProperty.Unit> howOftenOnlyHoursMinutesUnits = new ArrayList<UnitConfigProperty.Unit>();
        howOftenOnlyHoursMinutesUnits.add(new UnitConfigProperty.Unit(0.016666666666666666, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.hours", new Object[0])));
        howOftenOnlyHoursMinutesUnits.add(new UnitConfigProperty.Unit(1.0, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.minutes", new Object[0])));
        ArrayList<UnitConfigProperty.Unit> howOftenUnits = new ArrayList<UnitConfigProperty.Unit>(howOftenOnlyHoursMinutesUnits);
        howOftenUnits.add(0, new UnitConfigProperty.Unit(6.944444444444444E-4, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.days", new Object[0])));
        howOftenUnits.add(0, new UnitConfigProperty.Unit(9.92063492063492E-5, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.weeks", new Object[0])));
        howOftenUnits.add(0, new UnitConfigProperty.Unit(2.48015873015873E-5, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.months", new Object[0])));
        NumberField dateField = new NumberField(DATE_VALUE_TO_SET, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.valueToSet", new Object[0]), howOftenUnits);
        dateField.setValue("60");
        LabelField dateLabel = new LabelField("dateValueToSet.label", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.dateExplanation", new Object[0]));
        ArrayList<FieldCondition> dateConditions = new ArrayList<FieldCondition>();
        for (ActionVO action : ActionManager.getInstance().getAll(true)) {
            if (action.getId() != -3 && action.getId() != 10 && action.getStatusID() != 150 && action.getStatusID() != 260) continue;
            dateConditions.add(FieldCondition.visible((Field)actionFilter, (FieldCondition.OP)FieldCondition.OP.equals, (String)("" + action.getId())));
        }
        dateField.setConditions(dateConditions);
        dateLabel.setConditions(dateConditions);
        fields.add(dateField);
        fields.add(dateLabel);
        BooleanField applyWorkingHours = new BooleanField(WORKING_HOURS, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.workingHours", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("workingHours.postText", new Object[0]));
        applyWorkingHours.setValue("false");
        applyWorkingHours.setConditions(dateConditions);
        LabelField workingHoursLabel = new LabelField("ApplyActionAction.workingHours.label", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.workingHours.label", new Object[0]));
        workingHoursLabel.setConditions(dateConditions);
        fields.add(applyWorkingHours);
        fields.add(workingHoursLabel);
        ArrayList<UnitConfigProperty.Unit> timeSpentUnits = new ArrayList<UnitConfigProperty.Unit>();
        timeSpentUnits.add(new UnitConfigProperty.Unit(0.016666666666666666, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.hours", new Object[0])));
        timeSpentUnits.add(new UnitConfigProperty.Unit(1.0, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.minutes", new Object[0])));
        NumberField timeSpentField = new NumberField(TIME_SPENT, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.timeSpent", new Object[0]), timeSpentUnits);
        timeSpentField.setValue("");
        timeSpentField.setPlaceholder(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.timeSpent.notset", new Object[0]));
        ArrayList<FieldCondition> timeSpentConditions = new ArrayList<FieldCondition>();
        for (ActionVO action : ActionManager.getInstance().getAll(true)) {
            int clientEffortTimeConfig = ApplyActionToTicketActionFactory.getClientEffortTimeConfigOrDefault();
            if (action.getId() == -12 || action.getId() == -22 || action.getId() == 947474 || action.getId() == 947475 || 2 == clientEffortTimeConfig) continue;
            timeSpentConditions.add(FieldCondition.visible((Field)actionFilter, (FieldCondition.OP)FieldCondition.OP.equals, (String)("" + action.getId())));
        }
        timeSpentField.setConditions(timeSpentConditions);
        fields.add(timeSpentField);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/applyhdaction_32.png");
        String helpKey = "taskplanner.action.apply-action-to-ticket";
        ArrayList<String> placeholderKeys = new ArrayList<String>();
        placeholderKeys.add(JOB_RESULT);
        return new ResultActionInfo(this.getExtensionName(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.displayname", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.description", new Object[0]), iconURL, helpKey, fields, placeholderKeys);
    }

    private static int getClientEffortTimeConfigOrDefault() {
        Integer clientEffortTimeConfig = (Integer)ConfigurationManager.getInstance().getCurrent().getValue(HDConfigKeys.CLIENT_EFFORTTIME_CONFIG);
        if (clientEffortTimeConfig == null) {
            clientEffortTimeConfig = ServerOptions.isOptionSet((int)0x800000) ? Integer.valueOf(0) : Integer.valueOf(1);
        }
        return clientEffortTimeConfig;
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        Map props = definition.getProperties();
        String actionToApply = (String)props.get(PROPERTY_ACTION_TO_APPLY);
        if (actionToApply == null || actionToApply.isBlank()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.mustNotBeEmpty", new Object[0])});
        }
        String ticketId = (String)props.get("Ticket ID");
        if (ticketId == null || ticketId.isBlank()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.mustNotBeEmpty", new Object[0])});
        }
        int actionId = Integer.valueOf(actionToApply);
        if (actionId != 947474 && actionId != 947475) {
            String timeSpent;
            block15: {
                String receiver;
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId);
                if (actionVO == null) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.mustNotBeEmpty", new Object[0])});
                }
                if (actionToApply.equals("10") || actionToApply.equals("-3") || actionVO.getStatusID() == 260 || actionVO.getStatusID() == 150) {
                    String dateValue = (String)props.get(DATE_VALUE_TO_SET);
                    if (this.hasPlaceholderSet(dateValue, taskID)) {
                        return;
                    }
                    if (dateValue == null || dateValue.isBlank()) {
                        throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.nodate", new Object[0])});
                    }
                    try {
                        if (Long.valueOf(dateValue) < 0L) {
                            throw new NumberFormatException();
                        }
                        break block15;
                    }
                    catch (NumberFormatException e) {
                        throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.nodate", new Object[0])});
                    }
                }
                if (actionToApply.equals("-7") && ((receiver = (String)props.get(PROP_RECEIVER)) == null || receiver.isBlank())) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.needreceiver", new Object[0])});
                }
            }
            if ((timeSpent = (String)props.get(TIME_SPENT)) != null && !timeSpent.isBlank() && !timeSpent.contains("{")) {
                try {
                    if (Long.valueOf(timeSpent) < 0L) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.invalidTimeSpent", new Object[0])});
                }
            }
        }
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        String ticketId = (String)definition.getProperties().get("Ticket ID");
        String actionToApply = (String)definition.getProperties().get(PROPERTY_ACTION_TO_APPLY);
        String actionLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
        Integer actionId = Integer.valueOf(actionToApply);
        if (actionId == 947474) {
            actionLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setunread", new Object[0]);
        } else if (actionId == 947475) {
            actionLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("action.setread", new Object[0]);
        } else {
            ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId.intValue());
            if (actionVO != null && !actionVO.isDeleted()) {
                actionLabel = actionVO.getDisplayValue();
            }
        }
        SummaryInfo s = this.fieldValues.getSummary((AbstractDefinition)definition, ClientLocale.getThreadLocale().toLanguageTag(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.summary", new Object[]{actionLabel, ticketId}), "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.summary.desc", new Object[0]));
        String timeSpent = (String)definition.getProperties().get(TIME_SPENT);
        Object summarySuffix = "";
        int clientEffortTimeConfig = ApplyActionToTicketActionFactory.getClientEffortTimeConfigOrDefault();
        if (actionId == -12 || actionId == -22 || actionId == 947474 || actionId == 947475 || 2 == clientEffortTimeConfig) {
            timeSpent = "";
        }
        if (timeSpent != null && !timeSpent.isBlank()) {
            if (timeSpent.contains("{")) {
                summarySuffix = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.timeSpent", new Object[0]) + ": " + timeSpent + " " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.minutes", new Object[0]);
            } else {
                try {
                    int timeSpentMinutes = Integer.valueOf(timeSpent.trim());
                    if (timeSpentMinutes >= 0) {
                        String minuteLabel = timeSpentMinutes == 1 ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.minute", new Object[0]) : HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.minutes", new Object[0]);
                        summarySuffix = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ApplyActionAction.timeSpent", new Object[0]) + ": " + timeSpentMinutes + " " + minuteLabel;
                    }
                }
                catch (NumberFormatException e) {
                    HDLogger.debug((Object)e);
                }
            }
        }
        if (!((String)summarySuffix).isBlank()) {
            s.getEntries().add(new SummaryEntry("", (String)summarySuffix));
        }
        return s;
    }

    protected ApplyActionToTicketAction createInstanceFrom(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) {
        return new ApplyActionToTicketAction(definition, taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

