/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.processstarted;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.processstarted.ProcessStartedTriggerFactory;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.ActiveProcess;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class ProcessStartedTrigger
implements Trigger {
    public static int ACTION_EXECUTION_DELAY = 3000;
    private Trigger.TriggerAction triggerAction;
    private GUID processID;
    private String activityId;
    private GUID taskOwnerId;
    private final List<TicketOperationModel> alreadyTriggeredFor = Collections.synchronizedList(new ArrayList());

    public ProcessStartedTrigger(String processID, String activityId) {
        this.processID = processID == null || processID.isBlank() ? null : GUID.valueOf((String)processID);
        this.activityId = activityId;
    }

    public GUID getProcessID() {
        return this.processID;
    }

    public void activate(GUID taskID, Trigger.TriggerAction action) {
        TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(taskID);
        if (taskExecution != null) {
            this.taskOwnerId = taskExecution.getOwnerId();
        }
        this.triggerAction = action;
        ProcessStartedTriggerFactory.addListener(this);
    }

    public void deactivate() {
        this.triggerAction = null;
        ProcessStartedTriggerFactory.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketActionExtension checkForProcessChange(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments) {
        if ("ProcessStartedTrigger.OnProcessStart".equals(this.activityId) || "".equals(this.activityId)) {
            TicketProcess ticketProcess;
            if (action.getId() == -19 && (ticketProcess = ((ActiveProcess)arguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START)).getProcessDefinition()) != null && (this.processID == null || ticketProcess.getId().equals((Object)this.processID))) {
                return this.triggerExtensionFor(ticket);
            }
        } else if ("ProcessStartedTrigger.OnProcessEnd".equals(this.activityId)) {
            TicketProcess ticketProcess;
            Optional oldTicket;
            if (action.getId() == -34 && (oldTicket = ticket.getOldTicket()).isPresent() && (ticketProcess = TicketProcessManager.getProcessOfTicket((TicketVO)((TicketVO)oldTicket.get()))) != null && (this.processID == null || ticketProcess.getId().equals((Object)this.processID))) {
                return this.triggerExtensionFor(ticket);
            }
        } else {
            TicketProcess ticketProcess;
            boolean amInCorrectProcess = false;
            Optional oldTicket = ticket.getOldTicket();
            if (oldTicket.isPresent() && (ticketProcess = TicketProcessManager.getProcessOfTicket((TicketVO)((TicketVO)oldTicket.get()))) != null && ticketProcess.getId().equals((Object)this.processID)) {
                amInCorrectProcess = true;
            }
            if (!amInCorrectProcess && action.getId() == -19 && (ticketProcess = ((ActiveProcess)arguments.get(TicketProcessManager.EXT_ARG_PROCESS_TO_START)).getProcessDefinition()) != null && (this.processID == null || ticketProcess.getId().equals((Object)this.processID))) {
                amInCorrectProcess = true;
            }
            TicketOperationModel parentModel = ticket.getParentModel();
            Set newActivitiesResultingFromApplyProcess = parentModel.getChangedTickets().stream().map(t -> (GUID)t.getNewTicketAttributes().get(TicketProcessManager.ATTRIBUTE_ACTIVITY)).map(a -> a != null ? a.toString() : "").collect(Collectors.toSet());
            if (amInCorrectProcess && newActivitiesResultingFromApplyProcess.contains(this.activityId)) {
                List<TicketOperationModel> list = this.alreadyTriggeredFor;
                synchronized (list) {
                    if (!this.alreadyTriggeredFor.contains(parentModel)) {
                        this.alreadyTriggeredFor.add(parentModel);
                        new Thread(() -> {
                            List<TicketOperationModel> list = this.alreadyTriggeredFor;
                            synchronized (list) {
                                try {
                                    this.alreadyTriggeredFor.wait(5000L);
                                    this.alreadyTriggeredFor.remove(parentModel);
                                }
                                catch (InterruptedException e) {
                                    HDLogger.error((Object)e);
                                }
                            }
                        }, "process started trigger remove parent change model").start();
                        return this.triggerExtensionFor(ticket);
                    }
                }
            }
        }
        return null;
    }

    private TicketActionExtension triggerExtensionFor(OperationChangedTicket ticket) {
        try (UserAccountScope scope = UserAccountScope.create((GUID)this.taskOwnerId);){
            TicketPermissionContext permissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.createIntermediateTicketVO());
            if (!permissionInfo.hasResourceAccessToTicket() && !permissionInfo.hasDispatcherAccessToTicket()) {
                HDLogger.debug((Object)("Cannot trigger task due to missing permission in ticket " + ticket.getTicketId()));
                TicketActionExtension ticketActionExtension = null;
                return ticketActionExtension;
            }
        }
        return new TicketActionExtension(){

            public void extendTicketAction(final ActionVO action, final OperationChangedTicket ticket, final OperationNewReaStep reaStep, TicketSubOperations operations) {
                ticket.getAfterWriteOperations().add(() -> {
                    final Trigger.TriggerAction a = ProcessStartedTrigger.this.triggerAction;
                    if (a != null) {
                        final Timer t = new Timer("runTrigger");
                        t.schedule(new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try (UserAccountScope scope = UserAccountScope.create((GUID)ProcessStartedTrigger.this.taskOwnerId);){
                                    TicketOperationModel parentModel;
                                    Integer ticketIdOfTicketInCorrectActivity;
                                    int ticketIdToFetch = ticket.getTicketId();
                                    if (!("ProcessStartedTrigger.OnProcessStart".equals(ProcessStartedTrigger.this.activityId) || "".equals(ProcessStartedTrigger.this.activityId) || "ProcessStartedTrigger.OnProcessEnd".equals(ProcessStartedTrigger.this.activityId) || (ticketIdOfTicketInCorrectActivity = (parentModel = ticket.getParentModel()).getChangedTickets().stream().filter(t -> {
                                        GUID a2 = (GUID)t.getNewTicketAttributes().get(TicketProcessManager.ATTRIBUTE_ACTIVITY);
                                        return ProcessStartedTrigger.this.activityId.equals(a2 != null ? a2.toString() : "");
                                    }).findFirst().map(o -> o.getTicketId()).orElse(-1)) <= 0)) {
                                        ticketIdToFetch = ticketIdOfTicketInCorrectActivity;
                                    }
                                    TicketVO t2 = TicketManager.getReader().getTicket(ticketIdToFetch);
                                    Map<String, String> props = HDPlaceholderUtils.fillPlaceholderValuesFor(t2);
                                    int processChangeReaStep = reaStep.getReaStepId();
                                    ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(processChangeReaStep);
                                    ReaStepVO reaStepData = TicketManager.getReader().getReaStep(processChangeReaStep);
                                    props.putAll(HDPlaceholders.fillActionPlaceholderValuesFor(action, reaStepData, reaStepText));
                                    String ticketIDProp = props.get("Ticket ID");
                                    if (ticketIDProp != null) {
                                        props.put("Ticket ID", ticketIDProp.trim());
                                    }
                                    a.execute(props);
                                }
                                catch (AccessDeniedException ad) {
                                    HDLogger.debug((Object)"Cannot trigger task due to missing permissions");
                                    HDLogger.debug((Object)((Object)ad));
                                }
                                catch (Exception e) {
                                    HDLogger.error((Object)e);
                                }
                                finally {
                                    t.cancel();
                                }
                            }
                        }, ACTION_EXECUTION_DELAY);
                    }
                });
            }
        };
    }
}

