/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.hdformula;

import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.job.hdformula.HDFormulaJob;
import com.inet.id.GUID;
import com.inet.report.Engine;
import com.inet.report.FormulaField;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.TextAreaField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.ConditionInfo;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.job.JobSummaryInfo;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HDFormulaJobFactory
extends JobFactory<HDFormulaJob> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.formula";
    static final String VALUE_CONDITION = "VALUE_CONDITION";

    public HDFormulaJobFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getResultFlavors(JobDefinition definition) {
        return new ArrayList<ResultFlavor>();
    }

    protected void validateCondition(@Nonnull JobDefinition definition) throws ValidationException {
    }

    public JobInfo getInformation(@Nullable GUID taskID) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/hdformula_32.png");
        String helpKey = "taskplanner.job.hdformula";
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormulaName", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormulaDesc", new Object[0]);
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(new LabelField("desclabel", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormulaDesc", new Object[0])));
        TextAreaField t = new TextAreaField("hdformula", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.formula", new Object[0]));
        fields.add(t);
        ArrayList<TextField> conditionFields = new ArrayList<TextField>();
        TextField b = new TextField(VALUE_CONDITION, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.formula.valueCondition", new Object[0]));
        b.setValue("true");
        conditionFields.add(b);
        return new JobInfo(this.getExtensionName(), name, description, iconURL, helpKey, new ConditionInfo(conditionFields), fields, (List)new ArrayList<String>(){
            {
                this.add("hdformula");
            }
        });
    }

    protected HDFormulaJob createInstanceFrom(@Nonnull JobDefinition definition, @Nullable GUID taskID) {
        return new HDFormulaJob(definition);
    }

    protected void validate(@Nonnull JobDefinition definition, @Nullable GUID taskID) throws ValidationException {
        String formula = definition.getProperty("hdformula");
        Engine eng = RDC.createEmptyEngine((String)"java");
        try {
            formula = formula.replaceAll("\\{[^}]+\\}", "1");
            if (FormulaField.checkFormula((String)formula, (boolean)false, (Engine)eng) == -1) {
                throw new ReportException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.invalidFormula", new Object[0]), 0);
            }
        }
        catch (ReportException e) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.invalidFormula", new Object[0])});
        }
    }

    public JobSummaryInfo getSummary(@Nonnull JobDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        Object formula = definition.getProperty("hdformula");
        if (((String)formula).contains("\n")) {
            formula = ((String)formula).substring(0, ((String)formula).indexOf(10) + 1) + "...";
        }
        summary.add(new SummaryEntry("", (String)formula));
        ArrayList<SummaryEntry> conditionSummary = new ArrayList<SummaryEntry>();
        ConditionDefinition condition = definition.getCondition();
        if (condition != null) {
            String value = (String)condition.getProperties().get(VALUE_CONDITION);
            conditionSummary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.formula.conditionTitle", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.formula.valueConditionSummary", new Object[]{value})));
        }
        return new JobSummaryInfo(summary, conditionSummary);
    }

    public boolean isAutoResolvePlaceholders() {
        return false;
    }

    protected JobDefinition customPatchDefinitionProperties(JobDefinition baseDefinition, Map<String, String> seriesProperties, @Nullable GUID taskID) {
        String formula = baseDefinition.getProperty("hdformula");
        if (formula == null) {
            return super.customPatchDefinitionProperties(baseDefinition, seriesProperties, taskID);
        }
        JobDefinition patched = baseDefinition.copyDefinition();
        Map properties = patched.getProperties();
        for (Map.Entry<String, String> entry : seriesProperties.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            formula = formula.replace("{" + entry.getKey() + "}", value.replace("\"", "\"\""));
        }
        patched.setProperty("hdformula", formula);
        return patched;
    }
}

