/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TaskPlannerTicketActionListener;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange.StatusChangeTrigger;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TicketActionTrigger
extends StatusChangeTrigger
implements TaskPlannerTicketActionListener {
    private final List<Integer> actionIds;
    private GUID taskID;

    public TicketActionTrigger(TriggerDefinition definition, GUID taskID) {
        super(definition, new ArrayList<Integer>(), taskID);
        this.taskID = taskID;
        String actionsString = (String)definition.getProperties().get("PROPERTY_ACTION_TO_TRIGGER_ON");
        FilterableFieldListGenerator generator = FilterableFieldListGenerator.getInstance();
        ArrayList<DataEntry> actionKeys = generator.getActionKeys();
        String[] actionsArray = actionsString.split(";");
        List<String> actionList = Arrays.asList(actionsArray);
        this.actionIds = actionKeys.stream().filter(e -> actionList.contains(e.getLabel())).map(e -> Integer.valueOf(e.getValue())).collect(Collectors.toList());
    }

    @Override
    public void activate(GUID taskGUID, Trigger.TriggerAction triggerAction) {
        this.triggerAction = triggerAction;
        this.registerListener();
    }

    @Override
    protected void registerListener() {
        HDTaskPlannerDataListener.addTicketActionListener(this);
    }

    @Override
    public void deactivate() {
        this.triggerAction = null;
        this.unregisterListener();
    }

    @Override
    protected void unregisterListener() {
        HDTaskPlannerDataListener.removeTicketActionListener(this);
    }

    @Override
    public void handleTicketAction(OperationChangedTicket operationChangedTicket, ActionVO actionVO, MutableReaStepData mutableReaStepData) {
        List addedReaSteps = operationChangedTicket.getAddedReaSteps();
        String text = "";
        boolean isHtml = false;
        ReaStepVO reaStep = null;
        ReaStepTextVO reaText = null;
        TaskExecution execution = this.getTaskExecutionFor(this.taskID);
        GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
        if (addedReaSteps.size() > 0) {
            text = ((OperationNewReaStep)addedReaSteps.get(0)).getText().getText();
            isHtml = ((OperationNewReaStep)addedReaSteps.get(0)).getText().hasHtmlContent();
            int reaStepId = ((OperationNewReaStep)addedReaSteps.get(0)).getReaStepId();
            try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                reaStep = TicketManager.getReader().getReaStep(reaStepId);
                reaText = TicketManager.getReader().getReaStepText(reaStepId);
            }
            catch (AccessDeniedException exc) {
                return;
            }
        }
        int actionId = actionVO.getId();
        final int ticketId = operationChangedTicket.getTicketId();
        if (this.triggerAction == null) {
            return;
        }
        if (this.actionIds.contains(actionId)) {
            ActionVO actionVO1 = (ActionVO)ActionManager.getInstance().get(actionId);
            try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                this.ticketsChanged((List<Integer>)new ArrayList<Integer>(){
                    {
                        this.add(ticketId);
                    }
                }, actionVO1, reaStep, reaText, mutableReaStepData, text, isHtml);
            }
        }
    }
}

