/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.series.processstarted;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.series.processstarted.ProcessStartedSeries;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessStartedSeriesFactory
extends SeriesFactory<ProcessStartedSeries> {
    public static final String EXTENSION_NAME = "series.helpdesk.process-started";
    public static final String PROPERTY_PROCESS_FILTER = "processFilter";
    static TicketProcessManager tpmInstance;

    private static TicketProcessManager getTPMInstance() {
        if (tpmInstance != null) {
            return tpmInstance;
        }
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }

    public ProcessStartedSeriesFactory() {
        super(EXTENSION_NAME);
    }

    public SeriesInfo getInformation(@Nullable GUID guid) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ProcessStartedSeriesFactory.createProcessSelectField(fields);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/ticketprocesstrigger_32.png");
        return new SeriesInfo(this.getExtensionName(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedSeries.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedSeries.description", new Object[0]), iconURL, "taskplanner.series.process-started", fields);
    }

    public static void createProcessSelectField(ArrayList<Field> fields) {
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.any", new Object[0])));
        TicketProcessManager ticketProcessManager = ProcessStartedSeriesFactory.getTPMInstance();
        List processes = ticketProcessManager.getProcesses();
        processes.forEach(p -> values.add(new LocalizedKey(p.getId().toString(), p.getName())));
        SelectField selectField = new SelectField(PROPERTY_PROCESS_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter", new Object[0]), values);
        selectField.setValue("");
        fields.add((Field)selectField);
    }

    public void validate(@Nonnull SeriesDefinition definition, GUID guid) throws ValidationException {
    }

    public SummaryInfo getSummary(@Nonnull SeriesDefinition definition) {
        String s;
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String id = (String)definition.getProperties().get(PROPERTY_PROCESS_FILTER);
        TicketProcessManager ticketProcessManager = ProcessStartedSeriesFactory.getTPMInstance();
        TicketProcess process = ticketProcessManager.getProcess(GUID.valueOf((String)id));
        String string = s = process == null ? null : process.getName();
        if (s == null || s.trim().isEmpty()) {
            summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedSeriesSummaryInfoLabel", new Object[0])));
        } else {
            summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedSeriesSummaryInfoLabel.filtered", new Object[]{s})));
        }
        return new SummaryInfo(summary);
    }

    protected ProcessStartedSeries createInstanceFrom(@Nonnull SeriesDefinition definition, GUID guid) {
        return new ProcessStartedSeries(guid, definition);
    }

    @Nonnull
    public Set<String> getKeys(@Nonnull SeriesDefinition definition) {
        return new HashSet<String>(HDPlaceholders.getHDPlaceholderKeys());
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

