/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.taskplanner.cowork.server;

import com.inet.http.ClientMessageException;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.taskplanner.cowork.TaskPlannerCoWorkMessageServerPlugin;
import com.inet.plugin.taskplanner.cowork.server.data.CoWorkChannels;
import com.inet.plugin.taskplanner.cowork.server.data.CoWorkTeams;
import com.inet.plugin.taskplanner.cowork.server.util.b;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.taskplanner.server.api.action.PlaceholderResolver;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionHelper;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class a {
    private GUID b;
    private GUID c;
    private String d;
    private Boolean e = Boolean.FALSE;

    private a() {
    }

    public static a a(ResultActionDefinition resultActionDefinition) {
        a a2 = new a();
        Map map = resultActionDefinition.getProperties();
        String string = ResultActionHelper.getNonEmptyProperty((Map)map, (String)"teamChannel");
        String[] stringArray = string.split("-", 2);
        a2.b = stringArray.length > 0 ? GUID.valueOf((String)stringArray[0]) : null;
        a2.c = stringArray.length > 1 ? GUID.valueOf((String)stringArray[1]) : null;
        a2.d = ResultActionHelper.getNonEmptyProperty((Map)map, (String)"message");
        a2.e = Boolean.valueOf(ResultActionHelper.getNonEmptyProperty((Map)map, (String)"addAttachments"));
        return a2;
    }

    public HttpURLConnection a() {
        return this.a(this.b, this.c);
    }

    private HttpURLConnection a(@Nullable GUID gUID, @Nullable GUID gUID2) {
        return this.a((String)TaskPlannerCoWorkMessageServerPlugin.COWORK_SERVER.get(), (String)TaskPlannerCoWorkMessageServerPlugin.COWORK_TOKEN.get(), gUID, gUID2);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="The URL is set up by an administrative user account and must have the API sub-path for cowork.")
    private HttpURLConnection a(String string, String string2, @Nullable GUID gUID, @Nullable GUID gUID2) {
        if (StringFunctions.isEmpty((String)string)) {
            throw new com.inet.plugin.taskplanner.cowork.server.util.a(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.server.missing", new Object[0]), TaskPlannerCoWorkMessageServerPlugin.CONFIG_COWORK_SERVER);
        }
        if (StringFunctions.isEmpty((String)string2)) {
            throw new com.inet.plugin.taskplanner.cowork.server.util.a(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.token.missing", new Object[0]), TaskPlannerCoWorkMessageServerPlugin.CONFIG_COWORK_TOKEN);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (!string.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("api/cowork/teams/");
        if (gUID != null) {
            stringBuilder.append(gUID);
            stringBuilder.append("/channels/");
            if (gUID2 != null) {
                stringBuilder.append(gUID2);
                stringBuilder.append("/messages/");
            }
        }
        try {
            URL uRL = new URL(stringBuilder.toString());
            if (!uRL.getProtocol().startsWith("http")) {
                throw new com.inet.plugin.taskplanner.cowork.server.util.a(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.url.notHttp", new Object[0]), TaskPlannerCoWorkMessageServerPlugin.CONFIG_COWORK_SERVER);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + string2);
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)iOException));
        }
    }

    public void a(List<JobResultContainer> list) {
        HttpURLConnection httpURLConnection2 = this.a();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("text", this.d);
        if (this.e.booleanValue()) {
            this.a(httpURLConnection2, null, null, (HttpURLConnection httpURLConnection) -> {
                try (b b2 = new b((HttpURLConnection)httpURLConnection);){
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoOutput(true);
                    ArrayList<AttachmentDescription> arrayList = new ArrayList<AttachmentDescription>();
                    int n = 0;
                    for (JobResultContainer jobResultContainer : list) {
                        if (!jobResultContainer.areResultsProcessable()) continue;
                        List list2 = jobResultContainer.getResults(ResultFlavor.FILE);
                        for (Result result : list2) {
                            FileResult fileResult = (FileResult)result;
                            arrayList.add(new AttachmentDescription(fileResult.getFileName(), System.currentTimeMillis(), AttachmentType.Attachment));
                            b2.a("attachment" + n++, fileResult.getFileName(), fileResult.getFileContent());
                        }
                    }
                    if (arrayList.size() > 0) {
                        hashMap.put("attachments", (String)((Object)arrayList));
                    }
                    b2.a(hashMap);
                }
                catch (Exception exception) {
                    throw new ClientMessageException(exception.getMessage());
                }
            });
        } else {
            this.a(httpURLConnection2, hashMap, null, null);
        }
    }

    public <T> T a(HttpURLConnection httpURLConnection, @Nullable Object object, @Nullable Class<T> clazz) {
        return this.a(httpURLConnection, object, clazz, null);
    }

    public <T> T a(HttpURLConnection httpURLConnection, @Nullable Object object, @Nullable Class<T> clazz, @Nullable Consumer<HttpURLConnection> consumer) {
        try {
            Object object2;
            httpURLConnection.setRequestMethod(object == null ? "GET" : "POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setInstanceFollowRedirects(true);
            Json json = new Json();
            if (object != null) {
                httpURLConnection.setDoOutput(true);
                try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                    json.toJson(object, outputStream);
                }
            }
            if (consumer != null) {
                consumer.accept(httpURLConnection);
            }
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            switch (n) {
                case 200: {
                    break;
                }
                case 403: {
                    throw new ClientMessageException(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.error.forbidden", new Object[0]));
                }
                case 401: {
                    throw new ClientMessageException(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.error.denied", new Object[]{httpURLConnection.getURL().toExternalForm()}));
                }
                default: {
                    object2 = httpURLConnection.getInputStream();
                    try {
                        Map map = (Map)new Json().fromJson((InputStream)object2, Map.class, new Type[]{String.class, String.class});
                        String string = (String)map.get("error");
                        if (!StringFunctions.isEmpty((String)string)) {
                            throw new ClientMessageException(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.error.occurred", new Object[]{n, string}));
                        }
                        break;
                    }
                    finally {
                        if (object2 != null) {
                            ((InputStream)object2).close();
                        }
                    }
                }
            }
            if (clazz != null) {
                object2 = json.fromJson(httpURLConnection.getInputStream(), clazz);
                return (T)object2;
            }
        }
        catch (JsonException | IOException throwable) {
            throw new ClientMessageException(TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.genericerror.occurred", new Object[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)}));
        }
        finally {
            httpURLConnection.disconnect();
        }
        return null;
    }

    public static void a(String string, String string2) {
        a a2 = new a();
        HttpURLConnection httpURLConnection = a2.a(string, string2, null, null);
        a2.a(httpURLConnection, null, List.class);
    }

    public void b(List<JobResultContainer> list) {
        this.d = new PlaceholderResolver(this.d).addMetaData(list).resolve();
    }

    public void b() throws ValidationException {
        if (this.b == null) {
            throw new ValidationException(new String[]{TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.team.missing", new Object[0])});
        }
        if (this.c == null) {
            throw new ValidationException(new String[]{TaskPlannerCoWorkMessageServerPlugin.MSG.getMsg("config.channel.missing", new Object[0])});
        }
        try {
            this.a(this.a(), null, List.class);
        }
        catch (Throwable throwable) {
            throw new ValidationException(new String[]{throwable.getMessage()});
        }
    }

    @Nullable
    public static CoWorkTeams c() {
        a a2 = new a();
        HttpURLConnection httpURLConnection = a2.a(null, null);
        return a2.a(httpURLConnection, null, CoWorkTeams.class);
    }

    @Nullable
    public static CoWorkChannels a(GUID gUID) {
        a a2 = new a();
        HttpURLConnection httpURLConnection = a2.a(gUID, null);
        return a2.a(httpURLConnection, null, CoWorkChannels.class);
    }
}

